/**
 * @author sachin.bangar This is used for custom messages for paging toolbar
 */

Ext.define('Academia.utilities.ux.CustomPagingToolBar', {
	extend : 'Ext.toolbar.Paging',
	alias : 'widget.custompagingtoolbar',
	alternateClassName : [ 'CustomPagingToolBar' ],
	requires : [ 'Ext.toolbar.Paging' ],
	width:'100%',
	enableOverflow:true,
	hidden:true,
	cls: 'custompagingtoolbarCls',
	beforePageText: getCommonTranslation('PAGINATION_BEFORE_PAGE_TEXT'),
	displayMsg: getCommonTranslation('PAGINATIONDISPLAYMSG')+' '+'{0} - {1} of {2}',
	initComponent : function() {
		var this$ = this;
		Ext.applyIf(this$, {
			listeners : {
				beforerender : function(tbar) {
					this$.setConfigToPagingToolbar();
				},
				afterrender : function(tbar) {
					this$.getStoreCount();
				}
			}
		});
		this$.callParent(arguments);
	},
	setConfigToPagingToolbar: function(){
		if (this.store != undefined && this.store != null) {
			var win = this.up('window');
			//console.log("this.store", this.store);
			//console.log("win", win);
			if(win && !win.isDashlet){
				this.defaultStorePageSize = CONSTANTS.DEFAULT_WINDOW_GRID_PAGESIZE;//5
				if(this.store.storeId =="sunsuccess.BusinessRuleMappedFlagStore" || this.store.storeId =="examinationcenters.thesisManagement.ThesisManagementStatusGridStore"){
					this.defaultStorePageSize=10;
				}
				if(this.store.storeId =="examinationcenters.evaluationgrouplisting.centerallocation.EGCenterAllocationWinGrid" || this.store.storeId == "examexecution.StudentMarkRemarkCheckHistoryGridStore"){
					this.defaultStorePageSize=100;
				}
			} else if(win){
				this.defaultStorePageSize = 25; //maximized dashlet grid pageSize
			} else{
				if(this.store.storeId =="examinationcenters.evaluation.evaluationPlanHeirarchy.createGroup.StudentListForGrid"){
					this.defaultStorePageSize=100;
				} else if(this.store.storeId =="examinationcenters.calculateAverage.ExamResultDeletionGridStore"){
					this.defaultStorePageSize=100;
				} else if(this.store.storeId =="examinationcenters.remark.EvaluationRemarkGridStore" || this.store.storeId == "examinationcenters.remark.ClassTeacherRemarkGridStore"){
					this.defaultStorePageSize = 100;//10
				} else if(this.store.storeId =="manageMarksModeration.ManageMarksModerationGridStore"){
					this.defaultStorePageSize = 100;//10
				} else if(this.store.storeId =="coursetransaction.studentenrollment.enrollmentmaster.StudentCourseVariantStatusGrid"){
					this.defaultStorePageSize = 500;//10
				}else if(this.store.storeId =="examinationcenters.reports.PendingMarksStore"){
					this.defaultStorePageSize = 100;//10
				}else if(this.store.storeId =="examinationcenters.reports.PendingRemarksStore"){
					this.defaultStorePageSize = 100;//10
				}else if(this.store.storeId =="examinationOBEAttainment.AttainmentRuleGridStore"){
					this.defaultStorePageSize = 25;//10
				}else if( this.store.storeId == "bursaryApplicationStatusStore"){
					this.defaultStorePageSize = CONSTANTS.DEFAULT_WINDOW_GRID_PAGESIZE;
				}else if( this.store.storeId == "bursaryApplicationDetailStore"){
					this.defaultStorePageSize = CONSTANTS.DEFAULT_WINDOW_GRID_PAGESIZE;
				}else if(this.store.storeId =="examinationcenters.calculateAverage.ExamResultDeletionGridStore"){
					this.defaultStorePageSize=100;
				}else if(this.store.storeId =="admission.applicationFormSale.ApplicationCheckListDetailStore"){
					this.defaultStorePageSize=25;
				}else if(this.store.storeId =="ApplicationAndAdmissionCommentsModel"){
					this.defaultStorePageSize=25;
				}else if(this.store.storeId =="setup.campaignmaster.MapSchoolPriorityStore"){
					this.defaultStorePageSize=1000;
				}else{
					this.defaultStorePageSize = CONSTANTS.DEFAULT_TAB_GRID_PAGESIZE;//10
				}
			}
			this.store.pageSize = this.defaultStorePageSize;
			this.store.initialPageSize = this.defaultStorePageSize;
		}
	},
	/**
	 * hide show icon on load store
	 * 
	 * @params store paging store
	 */
	iconChange : function(store,grid) {
		var this$ = this;
		var count = store.getCount();
		var currentPage = this$.getPageData().currentPage;
		if (count == 0 && currentPage == 1) {
			this$.setVisible(true);
			this$.hideComponent();
			this$.showDisplayMsg();
			this$.showToolbarImage(grid);
		} else if ( !isNullOrEmpty(store.totalCount) && currentPage == 1 
				&& (store.totalCount <= this$.defaultStorePageSize) && this$.defaultStorePageSize<=store.pageSize) {
			this$.setVisible(false);
		} else {
			//this$.setVisible(true);
			this$.removeNoDataMsg();
			this$.removeToolbarImage(grid);
			//this$.showComponent();
			
		}
	},

	/**
	 * get Store count and hide/show paging icon
	 */
	getStoreCount : function() {
		if (this.store != undefined && this.store.getCount() == 0) {
			this.hideComponent();
			//this.showDisplayMsg();
		}
	},
	/**
	 * show paging icon
	 */
	showComponent : function() {
		Ext.each(this.items.items, function(obj) {
			obj.show();
		});
	},
	/**
	 * hide paging icon
	 */
	hideComponent : function() {
		Ext.each(this.items.items, function(obj) {
			obj.hide();
		});
	},
	/**
	 * show display message
	 */
	showDisplayMsg : function() {
		var displayItem = this.child('#displayItem');
		if (displayItem) {
			this.removeNoDataMsg();
			displayItem.show();
		} else {
			var noDataMsg = this.child('#nodata');
			if (noDataMsg == undefined) {
				this.add({
					xtype : 'label',
					text : getCommonTranslation('NODATADISPLAYMSG'),// 'No data
					// to
					// dislpay',
					itemId : 'nodata'
				});
			}
		}
	},
	showToolbarImage:function(grid){
		var displayItem = this.child('#displayItem');
		if (displayItem) {
			//this.removeNoDataMsg();
			var bottomToolbar = displayItem.up('custompagingtoolbar');
			bottomToolbar.setHeight(200);
			/*if(grid.xtype == 'griddashlet'){
				displayItem.addCls('dashletGridPaginationImageCls');
			}else if(grid.width =="33.33%"){
				displayItem.addCls('paginationImageClsForGrid');
			}
			else{*/
				//displayItem.addCls('paginationImageCls');
			/*}*/
				
				if(grid.xtype == 'griddashlet'){
					displayItem.addCls('dashletGridPaginationImageCls');
				}else{
					displayItem.addCls('paginationImageCls');
				}
				
			displayItem.show();
		}
	},
	removeToolbarImage:function(grid){
		var displayItem = this.child('#displayItem');
		if (displayItem) {
			//this.removeNoDataMsg();
			var bottomToolbar = displayItem.up('custompagingtoolbar');
			if(grid.xtype == 'griddashlet'){
				displayItem.removeCls('dashletGridPaginationImageCls');
			}else if(grid.width =="33.33%"){
				displayItem.removeCls('paginationImageClsForGrid');
			}
			else{
				displayItem.removeCls('paginationImageCls');
			}
			
			bottomToolbar.setHeight(0);
			bottomToolbar.setVisible(false)
			//displayItem.show();
		}
	},
	/**
	 * removing no data message
	 */
	removeNoDataMsg : function() {
		var noDataMsg = this.child('#nodata');
		if (noDataMsg != undefined || noDataMsg != null) {
			this.remove(this.child('#nodata'));
		}
	},
	
	getCustomPageData : function(){
        var store = this.store,totalCount,
        grid = this.up('grid');
        if(grid && grid.down('#totalRecordCount')  && !isNullOrEmpty(grid.down('#totalRecordCount').getValue())){
        	totalCount=this.up('grid').down('#totalRecordCount').getValue();
        }else{
        	totalCount = store.getTotalCount();
        }
        
        return {
            total : totalCount,
            currentPage : store.currentPage,
            pageCount: Math.ceil(totalCount / store.pageSize),
            fromRecord: ((store.currentPage - 1) * store.pageSize) + 1,
            toRecord: Math.min(store.currentPage * store.pageSize, totalCount)

        };
    },
	
	/**
	 * on load store
	 * overwrite method
	 */
	onLoad : function(){
        var me = this,
            pageData,
            currPage,
            pageCount,
            afterText,
            count,
            isEmpty,
            item;

        count = me.store.getCount();
        var grid = me.up('grid');
        
        isEmpty = count === 0;
        if(grid.down('#totalCountDisplayField') && grid.down('#totalCountDisplayField').isHidden()){
        	if (!isEmpty) {
                pageData = me.getPageData();
                currPage = pageData.currentPage;
                pageCount = pageData.pageCount;
                afterText = Ext.String.format(me.afterPageText, isNaN(pageCount) ? 1 : pageCount);
            } else {
            	pageData = me.getPageData();
                currPage = me.getPageData().currentPage;
                pageCount = me.getPageData().currentPage;
    			pageData.pageCount = pageCount;
    			afterText = Ext.String.format(me.afterPageText, isNaN(pageCount) ? 1 : pageCount);
            }
        }else{
        	if (!isEmpty) {
                pageData = me.getCustomPageData();
                currPage = pageData.currentPage;
                pageCount = pageData.pageCount;
                afterText = Ext.String.format(me.afterPageText, isNaN(pageCount) ? 1 : pageCount);
            } else {
            	pageData = me.getCustomPageData();
                currPage = me.getCustomPageData().currentPage;
                pageCount = me.getCustomPageData().currentPage;
    			pageData.pageCount = pageCount;
    			afterText = Ext.String.format(me.afterPageText, isNaN(pageCount) ? 1 : pageCount);
            }
        }

        Ext.suspendLayouts();
        item = me.child('#afterTextItem');
        if (item) {    
            item.setText(afterText);
        }
        item = me.getInputItem();
        if (item) {
            item.setDisabled(isEmpty).setValue(currPage);
        }
        me.setChildDisabled('#first', currPage === 1 && isEmpty);
        me.setChildDisabled('#prev', currPage === 1 && isEmpty);
        me.setChildDisabled('#next', currPage === pageCount  || isEmpty);
        me.setChildDisabled('#last', currPage === pageCount  || isEmpty);
        me.setChildDisabled('#refresh', false);
        me.updateInfo();
       grid.down('#firstButton') && grid.down('#firstButton').setDisabled(currPage === 1 || isEmpty);
        grid.down('#prevButton') && grid.down('#prevButton').setDisabled(currPage === 1 || isEmpty);
        grid.down('#nextButtonPaging') && grid.down('#nextButtonPaging').setDisabled(currPage === pageCount  || isEmpty);
        grid.down('#lastButton') && grid.down('#lastButton').setDisabled(currPage === pageCount  || isEmpty);
        var pagingDisplayField = grid.down('#pagingDisplayField');
        var pageSizeCombo = grid.down('#pageSizeCombo');
        if(pagingDisplayField && pageData){
        	if(grid.down('#totalCountDisplayField') && grid.down('#totalCountDisplayField').isHidden()){
        		pagingDisplayField.setValue(pageData.fromRecord + '-' + pageData.toRecord  + ' of '+ pageData.total.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ","));
        	}else{
        		pagingDisplayField.setValue(pageData.fromRecord + '-' + pageData.toRecord  + ' of ');
        	}
        	pagingDisplayField.setVisible(true);
        }
         if(pageSizeCombo && pageCount && me.down('combo')){
        	 if(grid.getStore() && grid.getStore().proxy && grid.getStore().proxy.extraParams.limit && grid.getStore().proxy.extraParams.limit != -1){
        		 pageSizeCombo.setValue(grid.getStore().proxy.extraParams.limit);
        	 }else{
        		 pageSizeCombo.setValue(me.down('combo').getValue());
        	 }
        	
        	pageSizeCombo.setDisabled(false);
        }
        Ext.resumeLayouts(true);
        if (me.rendered) {
            me.fireEvent('change', me, pageData);
        }
        me.iconChange(me.store,grid);
       
        if(grid.down('#totalRecordCount') && !isNullOrEmpty(grid.down('#totalRecordCount').getValue())){
        	grid.store.totalCount = grid.down('#totalRecordCount').getValue()
        }
    }
});