Ext.define('Academia.view.DMSView.CreateNewFolderWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.createnewfolderwindow',
	title:getDMSTranslation('CREATE_FOLDER'),
	frame: true,
	autoScroll:false,
	modal:true,
	method: 'POST',
	resizable:  false,
	height: 350,
	width: 510,
	items:[{
		xtype: 'form',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: 'vbox',
			defaults: {
				labelAlign: 'top',
				width:226
			},
			items: [{
				xtype : 'textfield',
				name : 'folderName',
				itemId:'folderNameItemId',
				allowBlank : false,
				fieldLabel : getDMSTranslation('NAME'),
				maxLength : 255
			},{
				xtype : 'textfield',
				name : 'folderTitle',
				itemId:'folderTitleItemId',
				allowBlank : true,
				fieldLabel : getDMSTranslation('TITLE'),
				maxLength : 1024
			},{	
				xtype: 'textarea',
				width:440,
				name: 'folderDescription',
				itemId:'folderDescriptionItemId',
				allowBlank:true,
				maxLength: 1024,
				fieldLabel: getDMSTranslation('DESCRIPTION')
			}]
		},{ 	
			xtype:'fieldcontainer',
			width:'auto',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				itemId: 'submitCreateFolderBtnWin',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelCreateFolderBtnWin',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});