/*
 * author @Harsh.Raghuwanshi
 * AcademiesFormWindow view for the Academies tab.
 */
Ext.define('Academia.view.DMSView.DmsUpdateWindow', {
	extend : 'Ext.window.Window',
	alias : 'widget.dmsupdatewindow',
	title : getCommonTranslation('DMS'),
	autoScroll : true,
	maxHeight : 900,
	maxWidth: 1000,
	modal : true,
	closeAction: 'destroy',
	items : [ {
		xtype : 'form',
		columns : 2,
		defaults : {
			width : 460,
			labelWidth: 150
		},
		plugins : "formlabelrequired",
		items : [{
			xtype : 'textfield',
			name : 'name',
			itemId:'dmsname',
			allowBlank : false,
			fieldLabel : getDMSTranslation('NAME'),
			enforceMaxLength : true,
			maxLength : 256
		}, {
			xtype : 'textfield',
			name : 'siteid',
			itemId:'dmssiteid',
			allowBlank : false,
			fieldLabel : getDMSTranslation('DMS_SITE_ID'),
			enforceMaxLength : true,
			maxLength : 72
		},{
			xtype: 'displayfield',
			fieldStyle: 'color: #767676 !important;',
			value: 'This is part of the site address. Use numbers and letters only.',
			fieldLabel : '&nbsp;',
			labelSeparator: ''
		},{	
			xtype: 'textarea',
			width:460,
			name: 'dmsdescription',
			itemId:'dmsdescription',
			allowBlank:true,
			fieldLabel: getDMSTranslation('DESCRIPTION')
		},{
			xtype: 'radiogroup',
			itemId:'visibility',
			name: 'visibility',
			fieldLabel: getDMSTranslation('VISIBILITY'),
			columns: 2,
			vertical: true,
			cls: 'radioLabelsTxt',
			items: [
				{ boxLabel: getDMSTranslation('PUBLIC')+'<br /><div class="boxLabelSmall">'+getDMSTranslation('PUBLIC_MSG')+'</div>', name: 'visibility', inputValue:"PUBLIC",checked:true},
				{ boxLabel: getDMSTranslation('MODERATED')+'<br /><div class="boxLabelSmall">'+getDMSTranslation('MODERATED_MSG')+'</div>', name: 'visibility', inputValue:"MODERATED"},
				{ boxLabel: getDMSTranslation('PRIVATE')+'<br /><div class="boxLabelSmall">'+getDMSTranslation('PRIVATE_MSG')+'</div>', name: 'visibility', inputValue:"PRIVATE"}
			]
		}, {
			xtype : 'fieldcontainer',
			width : '100%',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				action : 'Submit',
				text : getDMSTranslation('SAVE'),
				itemId : 'dmsSubmitButtonId',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			}, {
				xtype : 'button',
				itemId : 'dmsCancelButtonId',
				text : getDMSTranslation('CANCEL'),
				ui : 'CustomBtnCancel',
				scale : CONSTANTS.BUTTONSIZE
			} ]
		} ]
	} ]

});