Ext.define('Academia.view.DMSView.SiteDashboardSidePanel', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.sitedashboardsidepanel',
    margin: 0,
    title:getDMSTranslation("SITE_MEMBERS_TITLE"),
    border:  true,
    frame: true,
    items:[{
    	xtype: 'textfield',
    	width:'100%',
    	emptyText: getDMSTranslation('SEARCH'),
    	itemId: 'searchMappedUser',
    	enableKeyEvents: true
    },{
    	xtype: 'dataview',
    	itemId: 'userListDataViewItemId',
    	height: '90%',
    	autoScroll: true,
    	store: Ext.create('Academia.store.DMSStore.DMSSiteUserListStore'),
	    tpl: new Ext.XTemplate(
	    	    '<tpl for=".">',
	            '<div class="thumb-wrap">',
	              '<img src="resources/images/dms_user.png" />',
	              '<div><span class="dmsUserListNameSpan">{firstName} {lastName}</span><br /><span style="float: left;">{role}</span><span {[this.getClass(values)]}>x</span></div>',
	            '</div>',
	        '</tpl>',
	        {
    	    	getClass: function(values){
    	    		if(values.role=="Manager"){
	    	    		var classList = "style='display:none;'";
    	    		}
    	    		else{
	    	    		var classList = "class='deleteIcon'";
    	    		}
    	    		if(!values.isEditable){
    	    			var classList = "style='display:none;'";
    	    		}
    	    		return classList;
    	    	}
	        }
	    ),
	    itemSelector: 'div.thumb-wrap',
	    emptyText: 'No data available',
    }]
});