/**
 * @author Amit G
 */
Ext.define('Academia.view.admission.admissionActivityReport.SaleAdmissionEnrolProgramOverviewAdmGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.saleadmissionenrolprogramoverviewadmgrid',
    store: 'admission.admissionActivityReport.AdmissionEnrolProgramOverviewAdmGridStore',
    title: getAdmissionTranslation('SALES_ADMISSION_OVERVIEW_BY_PROGRAM'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        getRowClass: function (record, rowIndex, rowParams, store) {
            return (record.get('total') == 'total') ? 'gridAdmActivityReportEnrol' : '';
        },
        stripeRows: CONSTANTS.STRIPEROWS
    },
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    columns: [{
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocationName',
        flex: 1.5,
        sortable: false
    },{
        header: getCommonTranslation('INTAKE_YEAR'),
        dataIndex: 'intakeYear',
        flex: 1,
        sortable: false
    },{
        header: getCommonTranslation('PROGRAM_GROUP'),
        dataIndex: 'programGroupName',
        flex: 1,
        sortable: false
    },{
        header: getCommonTranslation('PROGRAM_NAME'),
        dataIndex: 'programName',
        flex: 1,
        sortable: false
    },{
        header: getAdmissionTranslation('ACADEMY_ENQUIRIES'),
        dataIndex: 'noOfEnquiry',
        flex: 1,
        sortable: false
    }, {
        header: getAdmissionTranslation('ACADEMY_APPLICATIONS'),
        dataIndex: 'noOfApplication',
        flex: 1,
        sortable: false
    }, {
        header: getAdmissionTranslation('ACADEMY_ACCEPTED_APPLICATIONS'),
        dataIndex: 'noOfApprovedApplication',
        flex: 1,
        sortable: false
    },{
        header: getAdmissionTranslation('ACADEMY_ADMISSION'),
        dataIndex: 'noOfApprovedAdmission',
        flex: 1,
        sortable: false
    }]
});
