/**
 * @author seshagiri.k
 */
Ext.define('Academia.view.admission.admissionCycle.AdmissionCycleSetupFilter', {
	//extend: 'Ext.form.Panel',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.admissioncyclesetupfilter',
    autoScroll: true,
    frame: false,
    layout: 'vbox',
    method: 'POST',
    cls:'customSearchPanel',
    standardSubmit: false,
    viewConfig: {
    	stripeRows : CONSTANTS.STRIPEROWS
    },
    bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,
    items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
    			fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
                name: 'academyLocationCombo',
                itemId:'academyLocationCombo',
                store: 'user.UserAcademyLocationStore',
                displayField: 'value',
                valueField: 'id',
                width:460,
                typeAhead : false,
                forceSelection:true,
                hideTrigger:false,
                queryMode: 'remote',
                queryParam: 'qry',
        	    triggerAction: 'all',
                minChars:3,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listConfig: {
    				  listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                    '{value}'  +
    	                    '</div>';
    	                }
    	            }
            },{
                xtype: 'customcombobox',
                name: 'intakeYear',
                itemId: 'intakeYearItemId',
                allowBlank:true,
                fieldLabel: getCommonTranslation('INTAKE_YEAR'),
                store: Ext.create('Academia.store.common.IntakeYearStore'),
                valueField: 'id',
                displayField: 'value',
                forceSelection: true,
                editable: true,
                typeAhead:false,
                cls:'commonAutoHeightMultiselectField',
                minChars:3,
                anyMatch:true,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				}
            },{
            	xtype: 'customcombobox',
    			name: ' programGroup',
    			itemId:'Program_Group',
    			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
    			store:'program.ProgramGroupStore',
    			editable: false,
    			valueField: 'id',
    			displayField: 'value',
    			forceSelection:true,
    			//allowBlank: false
            }]
        	},{
                xtype: 'fieldcontainer',
                width: 'auto',
                layout: {
                    type: 'hbox'
                },
                defaults: {
                    labelAlign: 'top',
                    width:226
                },
                items: [{
        			xtype: 'customcombobox',
        			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'), //Program
        			name: 'PROGRAM',
        			itemId: 'program',
        			autoload: false,
        			store: 'program.ProgramByGroupIdStore',
        			valueField: 'id',
        			displayField: 'valueCode',
        			queryParam:'qry',
        		//	typeAhead : true,
                    forceSelection:true,
                    hideTrigger:false,
                     triggerAction: 'all',
                    minChars:3,
                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                    listConfig: {
        				  listeners: {
        						beforeshow: function(picker) {
        							picker.minWidth = picker.up('combobox').getSize().width;
        						}
        					},
        	                loadingText: getCommonTranslation('SEARCHING'),
        	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        	                getInnerTpl: function() {
        	                    return '<div class="search-item">' +
        	                    '{code} / {value}'+ 
        	                    '</div>';
        	                }
        	            }
        		},{
        			xtype: 'customcombobox',
        			fieldLabel: getAdmissionTranslation('BATCH'),   //Batch
        			name: 'BATCH',
        			itemId: 'batch',
        			editable: true,
        			autoload: false,
        			typeAhead:false,
        			disabled:true,
        			valueField: 'id',
        			displayField: 'value',
        			queryMode : 'remote',
        			minChars:3,
        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        		    forceSelection:true,
        		       listConfig: {
        					listeners: {
        						beforeshow: function(picker) {
        							picker.minWidth = picker.up('combobox').getSize().width;
        						}
        					},
        					loadingText: getCommonTranslation('SEARCHING'),
        					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        					getInnerTpl: function() {
        						return '<div class="search-item">' +
        						'{code} / {value}'+ 
        						'</div>';
        					}
        			},
                    listeners: {
                        render: function(combo) {
                            var store = Ext.create('Academia.store.common.BatchesByProgramId');
                            combo.bindStore(store);
                        }
                    }
        		},{
        			xtype: 'customcombobox',
        			fieldLabel: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
        			name: 'SEAT_TYPE',
        			itemId: 'seatType',
        			editable: true,
        			autoload: false,
        			store:'Academia.store.common.SeatTypesByBatchId',
        			disabled:true,
        			valueField: 'seatTypeId',
        			displayField: 'seatTypeName',
        			queryMode : 'local',
        			forceSelection:true,
        			typeAhead:false,
        			minChars:3,
        			anyMatch:true,
        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
     				listConfig: {
     					listeners: {
     						beforeshow: function(picker) {
     							picker.minWidth = picker.up('combobox').getSize().width;
     						}
     					},
     					loadingText: getCommonTranslation('SEARCHING'),
     					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
     					getInnerTpl: function() {
     						return '<div class="search-item">' +
     						'{code}'  +
     						'</div>';
     					}
     				}
        		}]
            },{
                xtype: 'fieldcontainer',
                width: 'auto',
                layout: {
                    type: 'hbox'
                },
                defaults: {
                    labelAlign: 'top',
                    width:226
                },
                items: [{
        			xtype: 'customcombobox',
        			fieldLabel: getAdmissionTranslation('ADMISSION_CYCLE_STATUS'),
        			name: 'admissionCycleStatus',
        			itemId: 'admissionCycleStatus',
        			editable: false,
        			autoload: false,
        			store:'Academia.store.admission.admissionCycle.admissionCycleStatusStore',
        			valueField: 'value',
        			displayField: 'name',
        			queryMode : 'local'
        		},{
        			xtype: 'datefield',
        			name: 'START_DATE',
        			itemId: 'START_DATE',
        			vtype: 'daterange',
        			endDateField: 'END_DATE',
        			fieldLabel: getAdmissionTranslation('START_DATE'),
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			}
        		}, {
        			xtype: 'datefield',
        			name: 'END_DATE',
        			itemId: 'END_DATE',
        			vtype: 'daterange',
        			startDateField: 'START_DATE',
        			fieldLabel: getAdmissionTranslation('END_DATE'),
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			}
        		},{
        			xtype: 'checkboxfield',
        			labelAlign: 'right',
        			style:{
        				marginLeft:'8px',
        				marginTop:'25px'
        			},
        			boxLabel: getAdmissionTranslation('NOT_CONFIGURED_COMBINATIONS'),
        			name: 'notConfiureCombination',
        			itemId:'notConfiureCombination',
        			inputValue: true
				}]
            },{
            xtype: 'fieldcontainer',
            width: 'auto',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'quickSearchId',
                buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            },{
    			xtype: 'button',
    			itemId: 'resetBtn',
    			text: getCommonTranslation('RESET'),
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE
    		}]
        }]

});