/**
 * This panel is used in the Stage Settings Form of the admission Cycle.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.admissionCycle.StageSettingsForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.stagesettingsform',
    title: getAdmissionTranslation('STAGE_SETTING'),
    collapsible: true,
    frame:true,
    autoScroll: true,
    items: [{
        xtype: 'hidden',
        name: 'id'
    }, {   
    	xtype: 'hidden',
        name: 'currentStatus'
    }, {
        xtype: 'hidden',
        itemId: 'versionField',
        name: 'version'
    }, {
        xtype: 'nestedTextField',
        hidden:true,
        itemId: 'selectionProcessStage',
        name: 'selectionProcessStage'
    },{
        xtype: 'hidden',
        name: 'multipleIds'
    },{
        xtype: 'hidden',
        name: 'batchSlot'
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [/*{
            xtype: 'nestedJsonCombo',
            itemId: 'batchslotItemId',
            labelAlign: 'top',
            name: 'batchSlot',
            itemId: 'batchslotItemId',
            fieldLabel: getAdmissionTranslation('BATCH'),
            store: 'Academia.store.admission.admissionCycle.SelectionProcessesStageBatchSlot',
            displayField: 'value',
            valueField: 'id',
            autoload: false,
            editable:false,
            hidden: true,
            queryMode: 'local',
            allowBlank: true,
            width: 226
        },*/{
            xtype: 'nestedJsonCombo',
            itemId: 'programSelectionProcessStageCombo',
            labelAlign: 'top',
            name: 'programSelectionProcessStage',
            itemId: 'programSelectionProcessStageCombo',
            fieldLabel: getAdmissionTranslation('SELECTION_PROCESS_STAGES'),
            store: 'Academia.store.admission.admissionCycle.SelectionProcessesPickList',
            displayField: 'value',
            valueField: 'id',
            autoload: false,
            editable:false,
            queryMode: 'local',
            allowBlank: false,
            width: 226
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'textfield',
            itemId: 'droolsRulesComponent',
            name: 'entryRule',
            fieldLabel: getAdmissionTranslation('ENTRY_RULE_CRITERIA')
        },{
            xtype: 'textfield',
            name: 'exitRule',
            fieldLabel: getAdmissionTranslation('EXIT_RULE_CRITERIA')
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'textarea',
            name: 'entryRuleDescription',
            fieldLabel: getAdmissionTranslation('ENTRY_RULE_DESCRIPTION')
        },{
            xtype: 'textarea',
            name: 'exitRuleDescription',
            fieldLabel: getAdmissionTranslation('EXIT_RULE_DESCRIPTION')
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'numberfield',
            name: 'minSeat',
            fieldLabel: getAdmissionTranslation('MIN_SEAT_LIMIT'),
            vtype: 'numberrange',
    		itemId: 'minSeatLimit',
    		totalNumberField: 'maxSeatLimit',
    		allowBlank: false,
    		minValue: 0
        }, {
            xtype: 'numberfield',
            name: 'maxSeat',
            fieldLabel: getAdmissionTranslation('MAX_SEAT_LIMIT'),
            vtype: 'numberrange',
    		itemId: 'maxSeatLimit',
    		allowBlank: false,
    		variableNumberField: 'minSeatLimit'
        },{
            xtype: 'nestedJsonCombo',
            itemId: 'programSelectionDroolItemId',
            labelAlign: 'top',
            name: 'droolBatchMapping',
            itemId: 'programSelectionDroolItemId',
            fieldLabel: getCommonTranslation('DROOL'),
            store: 'Academia.store.admission.admissionCycle.DroolBatchMappingStore',
            displayField: 'value',
            valueField: 'id',
            autoload: false,
            editable:false,
            queryMode: 'local',
            allowBlank: true,
            width: 226
        }]
    },{
        xtype: 'fieldcontainer',
        defaults: {
            width: 226
        },
        layout: {
            type: 'hbox'
        },
        items: [{
        	xtype: 'checkboxfield',
			itemId : 'isFeePlanApplicable',
			labelAlign: 'right',
			region: 'south',
			boxLabel: getAdmissionTranslation('ISFEE_PLAN_APPLICABLE'),
			name: 'whetherFeePlanApplicable',
			inputValue: true,
			checked: false
        }]
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'nestedJsonCombo',
            name: 'feePlan',
            itemId: 'admissionFeePlan',
            fieldLabel: getAdmissionTranslation('ADMISSION_FEE_PLAN'),
            store: 'Academia.store.admission.admissionCycle.StageSettingFeePlanStore',
            displayField: 'value',
            //allowBlank:false,
            valueField: 'id',
            hidden:true
          
        }, {
            xtype: 'nestedJsonCombo',
            name: 'feePlanRule',
            itemId: 'admissionFeePlanRule',
            fieldLabel: getAdmissionTranslation('ADMISSION_FEE_PLAN_RULE'),
            store: 'Academia.store.admission.admissionCycle.StageSettingFeePlanRuleStore',
            displayField: 'value',
            valueField: 'id',
            disabled:true,
            allowBlank:false,
            hidden:true
            
        }]
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'nestedJsonCombo',
            name: 'feePlanRuleStage',
            itemId: 'admissionStageFeePlan',
            fieldLabel: getAdmissionTranslation('ADMISSION_STAGE_FEE_PLAN'),
            store: 'Academia.store.admission.admissionCycle.StageSettingFeePlanStageStore',
            displayField: 'value',
            hidden:true,
            valueField: 'id',
            disabled:true,
            allowBlank:false,
            
        }, {
        	xtype: 'textfield',
            name: 'stageFeeAmount',
            itemId: 'admissionAmountToPaid',
            fieldLabel: getAdmissionTranslation('ADMISSION_AMOUNT_TO_PAID'),
            displayField: 'value',
            hidden:true,
            valueField: 'id',
            readOnly:true
            //allowBlank:false
            
        }]
    },{
    	xtype: 'fieldcontainer',
        defaults: {
            width: 226
        },
        layout: {
            type: 'hbox'
        },
        items: [{
        	xtype: 'checkboxfield',
			itemId : 'allowSystemByPass',
			labelAlign: 'right',
			region: 'south',
			boxLabel: getAdmissionTranslation('ALLOW_SYSTEM_TO_BY_PASS'),
			name: 'whetherFeePlanByPass',
			inputValue: true,
			hidden:true
        }]
    	
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            name: 'startDate',
            fieldLabel: getAdmissionTranslation('START_DATE'),
            vtype: 'daterange',
            itemId: 'startDate',
            endDateField: 'endDate',
            allowBlank: false,
          //--submitFormat: CONSTANTS.DATE_FORMAT,
//            format: CONSTANTS.DATE_FORMAT,
            listeners:{
            	render: function(field) {
            		return dateFormatRender(field);
            	},
            	change:function(cmp,value){
            		if(!value){
            			var nextField=cmp.nextSibling();
            			nextField.setMinValue(false);
            		}
            	}
            }

        }, {
            xtype: 'datefield',
            name: 'endDate',
            fieldLabel: getAdmissionTranslation('END_DATE'),
            itemId: 'endDate',
            vtype: 'daterange',
            startDateField: 'startDate',
            allowBlank: false,
          //--submitFormat: CONSTANTS.DATE_FORMAT,
//            format: CONSTANTS.DATE_FORMAT,
            listeners:{
            	change:function(cmp,value){
            		if(!value){
            			var nextField=cmp.previousSibling();
            			nextField.setMaxValue(false);
            		}
            	},
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            }
        }, {
        	xtype: 'livesearchcombo',
    	    labelAlign: 'top',
    	    width: 226,
        	name: 'approverAuthority',
        	itemId:'approverAuthority',
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	fieldLabel: getAdmissionTranslation('APPROVAL_AUTHORITY')
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	  xtype: 'button',
              itemId: 'btnSaveSelectionProcess',
              text: getCommonTranslation('SAVE'),
              ui: 'CustomBtnSubmit',
              scale: CONSTANTS.BUTTONSIZE,
              formBind: true
        }]
    }]
});