/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show program details in grid 
 */
var addProgramWindowGridStore=Ext.create('Academia.store.admission.applicationFormSale.AddProgramGridStore');
Ext.define('Academia.view.admission.applicationFormSale.AddProgramWindowGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.addprogramwindowgrid',
    title: getAdmissionTranslation('SELECT_PROGRAM'),
    addApplicationProgramType:'',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    isGridConfigurable: true,
    enableColumnHide: false,
    plugins:[],
    border: true,    
    selModel:Ext.create('Ext.selection.CheckboxModel',{
    	//singleSelect: true,
		checkOnly: true,
	    mode: 'multi',
    	showHeaderCheckbox : false
    }),
    //selType: 'checkboxmodel',
    initComponent: function() {
    	var grid=this;                
    	var store=addProgramWindowGridStore;
    	var columns =new Array();
    	var columnArray=new Array();
    	var toolBarItems=new Array();
    	if (!isNullOrEmpty(grid.addApplicationProgramType) && grid.addApplicationProgramType === 'APPLICANT_PROFILE_ADD_APPLICATION_PROGRAMS') {    		
    			store.getProxy().api.read = SERVERURL.PATH_FIND_CONFIGURED_FLAG_BASED_PROGRAMS_BY_PROGRAMGROUPID;
    			columnArray=columnArray.concat(grid.getFixedColumns());
    			columnArray=columnArray.concat(grid.getExtraColumns());    			
    			columns=columnArray;        	         	        	
    			toolBarItems=grid.getToolBarItems(false);
    			grid.plugins.push(Ext.create('Ext.grid.plugin.CellEditing', {
                    clicksToEdit: 1
                }));
    			grid.selModel=Ext.create('Ext.selection.CheckboxModel',{    		    	
    				checkOnly: true,
    			    mode: 'multi'
    		    });
    			//grid.selType= 'checkboxmodel';
       } else if (!isNullOrEmpty(grid.addApplicationProgramType) &&  grid.addApplicationProgramType === 'APPLICATION_FORM_SALE_ADD_APPLICATION_PROGRAMS') {    	   		
    	   		store.getProxy().api.read = SERVERURL.PATH_FIND_CONFIGURED_FLAG_BASED_PROGRAMS_BY_PROGRAMGROUPID;
    	   		columnArray=columnArray.concat(grid.getFixedColumns());
				columns=columnArray;
				toolBarItems=grid.getToolBarItems(false);
				grid.plugins.push(Ext.create('Ext.grid.plugin.CellEditing', {
                    clicksToEdit: 1
                }));
				grid.selModel=Ext.create('Ext.selection.CheckboxModel',{    		    	
    				checkOnly: true,
    			    mode: 'multi'
    		    });
       } else if (!isNullOrEmpty(grid.addApplicationProgramType) &&  grid.addApplicationProgramType === 'ADMISSION_ADD_APPLICATION_PROGRAMS') {
    	   store.getProxy().api.read = SERVERURL.APPLICATION_FORM_SALE_PROGRAM_WINDOW_GRID_DATA;
    	   columnArray=columnArray.concat(grid.getFixedColumns());				    	   		    	   		
    	   columns=columnArray;
    	   toolBarItems=grid.getToolBarItems(true,true);
    	   grid.plugins.push(Ext.create('Ext.grid.plugin.CellEditing', {
                    clicksToEdit: 1
                }));
    	   grid.selModel= Ext.create('Ext.selection.RowModel',{    		    					
			    mode: 'SINGLE'
		    });
       }
        this.doLayout();
        Ext.apply(this, {
            store: store,
            columns: columns,
            tbar:toolBarItems
        });
        this.callParent(arguments);
        var custompagingtoolbar=grid.down('custompagingtoolbar');
        if(custompagingtoolbar){
        	custompagingtoolbar.bindStore(store);        	
        }
        if (!isNullOrEmpty(grid.addApplicationProgramType) &&  grid.addApplicationProgramType === 'ADMISSION_ADD_APPLICATION_PROGRAMS'){
        	custompagingtoolbar.setVisible(false);
        } 
    },
    columns: [],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            displayInfo: true,
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE')           
        }]
    }],
    getExtraColumns:function(){
    	var extraColumns=[/*{
    		header: getAdmissionTranslation('HOSTEL'), //Hostel        
    		dataIndex: 'whetherHostelApplicable',        
    		flex: .2,
    		editor: {
                xtype: 'customcombobox',
                name: 'hostel',            
                  //Select Hostel             
                store:'Academia.store.common.YesNoClientSideComboStore',
                valueField:'name',
                displayField:'value',
                editable:false,
                queryMode:'local'            
            },
            renderer: function(val) {
                if (isNullOrEmpty(val)) {
                    return getAdmissionTranslation('CLICK_HERE');  //Click Here
                } else {
                    return val;
                }

            }
    	},*/{
    		header: getCommonTranslation('DISTANCE_TO_TRAVEL'), //Distance  to Travel        
    		dataIndex: 'distancetoTravel',        
    		flex: .2 ,
    		hidden: true,
    		editor: {
                xtype: 'numberfield',
                name: 'distanceToTravel',
                 //Enter distance  to Travel Value
                maxLength: 50,
                minValue:0
            },            
            renderer: function(val) {
                if (isNullOrEmpty(val)) {
                    return getAdmissionTranslation('CLICK_HERE');  //Click Here
                } else {
                    return val;
                }

            }
    	},{
    		header: getCommonTranslation('TRANSPORT'), //Transport        
    		dataIndex: 'whetherTransportApplicable',        
    		flex: .2,
    		hidden: true,
    		editor: {
                xtype: 'customcombobox',
                name: 'transport',            
                  //Select Transport             
                store:'Academia.store.common.YesNoClientSideComboStore',
                valueField:'name',
                displayField:'value',
                editable:false,
                queryMode:'local'            
            },
            renderer: function(val) {
                if (isNullOrEmpty(val)) {
                    return getAdmissionTranslation('CLICK_HERE');  //Click Here
                } else {
                    return val;
                }

            }
    	}];
    	
    	return extraColumns;
    },
    getFixedColumns:function(){
    	var fixedColumns=[{
            header: getCommonTranslation('ACADEMY'), //Academy 
            dataIndex: 'academy.value',
            flex: .2,
            sortable: true
        }, {
            header: getCommonTranslation('LOCATION'), //Location
            dataIndex: 'location.value',
            flex: .2,
            sortable: true
        }, {
            header: getCommonTranslation('PROGRAM'), //Program
            dataIndex: 'program.value',
            flex: .2,
            sortable: true
        }, {
            header: getCommonTranslation('MODE_OF_DELIVERY'),
            dataIndex: 'modeOfDelivery.value',
            sortable: true,
            flex: .2,
        	hidden: true,
        }, {
            header: getCommonTranslation('REGISTRATION_TYPE'),
            dataIndex: 'batchPartTime',
            sortable: true,
            flex: .2,
        	hidden: true,
        	renderer : function(value) {
            	if(!isNullOrEmpty(value)) {
            		if(value==false) {
            			return 'Full Time';
            		}
            		else {
            			return 'Part Time';
            		}
            	}
            }
        }, {
            header: getCommonTranslation('BATCH'), //Batch
            dataIndex: 'batch.value',
            flex: .2,
            sortable: true
        }, {
            header: getCommonTranslation('SEAT_TYPE'), //Seat Type
            dataIndex: 'seatType.value',
            flex: .2,
            sortable: true
        }, {
            header: getCommonTranslation('SCHOOL_ATTENDANCE_START_DATE'),
            dataIndex: 'schoolAttendanceStartDate',
            flex: .2,
            sortable: true,
			editor: {
				xtype: 'datefield',
				itemId: 'schoolAttendanceStartDate',
				name: 'schoolAttendanceStartDate',
				minValue: new Date(),
				vtype: 'daterange',
				submitFormat: 'timestamp',
				editable: false,
				listeners: {
					render: function(field) {
						dateFormatRender(field);
					}
				}
			},
			renderer: function(val) {
				if(!isNullOrEmpty(val)){
                   return dateRender(val);
                }
			}
        }];
    	
    	return fixedColumns;
    },
    getToolBarItems:function(hiddenValue,directAdmisison){
	 	var store;
	 	var items;
	 	if(directAdmisison)
	 		 store=Ext.create('Academia.store.admission.applicationFormSale.ProgramGroupComboStore');
	 	else{
	 		store=Ext.create('Academia.store.admission.applicationFormSale.ProgramGroupComboStore');
	 		//store=Ext.create('Academia.store.facilitiesresources.resourcebooking.AcademyLocationListStore');
	  	}
	   items = Ext.define('Academia.view.common.AddApplicationProgramForm', {
	 		 extend:'Academia.view.common.IdGeneratorCustomForm',
	 		 alias : 'widget.addapplicationprogramform',
	 		 items:[{
	 			 xtype: 'fieldcontainer',
	 			 layout:'vbox',
	 			 style:{
	 				borderLeft:'1px solid',
	 				borderRight:'1px solid',
	 				borderColor:'#e0e0e0',
	 				marginBottom:'0px'
	 			 },
	 			 width: '100%',
	 			 items:[{
	 				 xtype: 'fieldcontainer',
	 				 layout:'hbox',
	 				 width: '100%',
	 				 style :{marginLeft: '8px'
	 				 },
	 				 items:[{
	 					 xtype: 'customcombobox',
	 					 name: 'academyLocations',
	 					 itemId: 'cmbAcademyLocations',
	 					 hidden:hiddenValue,
	 					 fieldLabel: getAdmissionTranslation('SELECT_ACADEMY_LOCATION'), //Select Program Gorup
	 					 //Select Program Gorup  
	 					 labelWidth:150,
	 					 width:220,
	 					 labelAlign: 'top',
	 					 enableKeyEvents:true,
                         store:Ext.create('Academia.store.common.AcademyLocationNameSeparated'),
	 					 valueField: 'id',
	 					 displayField: 'value',
	 					 editable: true,
                         queryMode: 'remote',
	 					 triggerAction: 'all',
	 					 //forceSelection: false,
	 					 queryParam:'qry',
	 					 minChars:3,
	 					 allowBlank: true,
	 					 typeAhead:false,
	 					 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	 					 forceSelection:true,
	 					 listConfig: {
	 						 listeners: {
	 							 beforeshow: function(picker) {
	 								 picker.minWidth = picker.up('combobox').getSize().width;
	 							 }
	 						 },
	 						 loadingText: getCommonTranslation('SEARCHING'),
	 						 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	 						 getInnerTpl: function() {
	 							 return '<div class="search-item">' +
	 							 '{code} / {value}'+ 
	 							 '</div>';
	 						 }
	 					 }
	 				 },{
	 					 xtype: 'customcombobox',
	 					 name: 'pgmGroup',
	 					 itemId: 'cmbPgmGroup',
	 					 hidden:hiddenValue,
	 					 fieldLabel: getAdmissionTranslation('SELECT_PROGRAM_GROUP'), //Select Program Gorup
	 					 //Select Program Gorup  
	 					 labelWidth:150,
	 					 width:220,
	 					 //width:460,
	 					 labelAlign: 'top',
	 					 store:store,
	 					 valueField: 'id',
	 					 displayField: 'value',
	 					 editable: false,
	 					 queryMode: 'local',
	 					 triggerAction: 'all',
	 					 forceSelection: true,
	 					 allowBlank: false            
	 				 },{
	 					 xtype: 'customcombobox',
	 					 name: 'modeofDelivery',
	 					 itemId: 'modeDeliveryId',
	 					 hidden:hiddenValue,
	 					 fieldLabel: getCommonTranslation('MODE_OF_DELIVERY'), 
	 					 labelWidth:150,
	 					 width:220,
	 					 labelAlign: 'top',
	 					 store:Ext.create('Academia.store.common.ModeOfDeliveryStore'),
	 					 valueField: 'id',
	 					 displayField: 'value',
	 					 editable: false,
	 					 queryMode: 'local',
	 					 triggerAction: 'all',
	 					 forceSelection: true,
	 					 allowBlank: true 
	 				 },{
	 					 xtype: 'customcombobox',
	 					 name: 'registrationType',
	 					 itemId: 'registrationTypeId',
	 					 hidden:hiddenValue,
	 					 fieldLabel: getCommonTranslation('REGISTRATION_TYPE'), 
	 					 labelWidth:150,
	 					 width:220,
	 					 labelAlign: 'top',
	 					 store: Ext.create('Academia.store.campaignnew.RegistrationTypeStore'),
	 					 valueField: 'id',
	 					 displayField: 'value',
	 					 editable: false,
	 					 queryMode: 'local',
	 					 triggerAction: 'all',
	 					 forceSelection: true,
	 					 allowBlank: true            
	 				 },{
	 					 xtype: 'customcombobox',
	 					 name: 'programs',
	 					 itemId: 'cmbPrograms',
	 					 hidden:hiddenValue,
	 					 fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'), //Select Program Gorup
	 					 //Select Program Gorup  
	 					 labelWidth:150,
	 					 width:220,
	 					 labelAlign: 'top',
	 					 //width:460,
	 					 store:Ext.create('Academia.store.common.ProgramStoreAccessible'),
	 					 valueField: 'id',
	 					 displayField: 'valueCode',
	 					 editable: true,
	 					 queryMode: 'remote',
	 					 triggerAction: 'all',
	 					 queryParam:'qry',  
	 					 minChars:3,
	 					 allowBlank: true,
	 					 typeAhead:false,
	 					 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	 					 forceSelection:true,
	 					 listConfig: {
	 						 listeners: {
	 							 beforeshow: function(picker) {
	 								 picker.minWidth = picker.up('combobox').getSize().width;
	 							 }
	 						 },
	 						 loadingText: getCommonTranslation('SEARCHING'),
	 						 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	 						 getInnerTpl: function() {
	 							 return '<div class="search-item">' +
	 							 '{code} / {value}'+ 
	 							 '</div>';
	 						 }
	 					 }            
	 				 }]},
	 				 {
	 					 xtype: 'fieldcontainer',
	 					 layout:'hbox',
	 					 width: '100%',
	 					 style :{marginLeft: '8px'},
	 					 items: [{
	 						 xtype: 'button',
	 						 text: getCommonTranslation('SEARCH'),
	 						 itemId: 'quickSearchId',
	 						 buttonAlign: 'left',
	 						 formBind:true,
	 						 ui: 'CustomBtnSubmit',
	 						 scale: CONSTANTS.BUTTONSIZE
	 					 },{
	 						 xtype: 'button',
	 						 itemId: 'resetBtn',
	 						 text: getCommonTranslation('RESET'),
	 						 ui:'CustomBtnCancel',
	 						 scale: CONSTANTS.BUTTONSIZE,
	 						 buttonAlign: 'left',
	 					 }]
	 				 }]
	 		 }]
	 	});
	 return items;
    }  
});
