/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.admission.applications.applicantProfileBase.AcceptOfferLetterWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.acceptofferletterwin',
    title: getAdmissionTranslation('APOL_OFFER_ACCEPTANCE'),
    frame: true,
    modal: true,
    id: 'countWinItemId',
    method: 'POST',
    resizable: true,
    autoScroll: true,
    height: '52%',
    width: '50%',
    items: [{
        xtype: 'form',
        extend:'Academia.view.common.IdGeneratorCustomForm',
	 	alias : 'widget.offerLetterAcceptanceForm',
        itemId: 'acceptOfferLetterFormItemId',
        items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            style: {
                marginTop: '0px',
                marginLeft: '10px',
            },
            items: [{
                xtype: 'displayfield',
                style: {
                    height: 'auto',
                    textAlign: 'justify'
                },
                flex: 1,
                value: '<p style=\'font: normal 13px/17px Open Sans, sans-serif, Myriad Pro;margin:5px 0px;\'>' + getAdmissionTranslation('APOL_ACCEPT_OFFER_LETTER_WIN_MESSAGE') + '</p>',
            }]
        }, {
        	xtype: 'fieldcontainer',
        	layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            style: {
                marginTop: '0px',
                marginLeft: '10px',
            },
            items: [{
            	xtype: 'customcombobox',
            	fieldLabel: getAdmissionTranslation('OFFER_LETTER_ACCEPTED_BY'),
	            name: 'offerLetterAcceptedBy',
	            itemId: 'offerLetterAcceptedBy',
	            valueField: 'id',
	            displayField: 'value',
	            store: 'common.OfferLetterAcceptedByStore',
	            forceSelection: true,
	            queryMode: 'local',
	            allowBlank: true,
	            matchFieldWidth:true,
	            hidden:true
            }]
        }, {
            xtype: 'fieldcontainer',
            itemId: 'isRegistrationContract2FieldContainer',
            layout: 'hbox',
            style: {
                marginTop: '5px',
                marginLeft: '10px'
            },
            items: [{
                xtype: 'checkboxfield',
                name: 'isRegistrationContract2',
                itemId: 'isRegistrationContract2ItemId',
                width: 'auto',
                labelAlign: 'right',
                style:{'margin-top':'5px !important'},
                inputValue: true,
                allowBlank: false,
                uncheckedValue: false
            },{
                xtype: 'displayfield',
                style: {
                    height: 'auto',
                    textAlign: 'justify'
                },
                flex:1,
                value: '<p style=\'font: normal 13px/17px Open Sans, sans-serif, Myriad Pro;margin:12px 0px;\'>' + getAdmissionTranslation('APOL_REGISTRATION_CONTRACT_CHECKBOX_TEXT2') + '</p>',
            }]

        }, {
            xtype: 'fieldcontainer',
            itemId: 'isRegistrationContractFieldContainer',
            layout: 'hbox',
            style: {
                marginTop: '5px',
                marginLeft: '10px'
            },
            items: [{
                xtype: 'checkboxfield',
                name: 'isRegistrationContract',
                itemId: 'isRegistrationContractItemId',
                width: 'auto',
                labelAlign: 'right',
                style:{'margin-top':'5px !important'},
                inputValue: true,
               // allowBlank: false,
                uncheckedValue: false
            },{
                xtype: 'displayfield',
                style: {
                    height: 'auto',
                    textAlign: 'justify'
                },
                flex:1,
                value: '<p style=\'font: normal 13px/17px Open Sans, sans-serif, Myriad Pro;margin:12px 0px;\'>' + getAdmissionTranslation('APOL_REGISTRATION_CONTRACT_CHECKBOX_TEXT') + '</p>',
            }]

        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            style: {
                marginTop: '5px',
                marginLeft: '10px',
            },
            items: [{
                xtype: 'displayfield',
                name: 'offerLetterDisclaimer',
                itemId: 'offerLetterDisclaimer',
                style: {
                    height: 'auto',
                    textAlign: 'justify'
                },
                flex: 1,
                value: '<p style=\'font: normal 13px/17px Open Sans, sans-serif, Myriad Pro;margin:0px 0px;\'>' + getAdmissionTranslation('APOL_ACCEPT_OFFER_LETTER_WIN_DISCLAIMER') + '</p>',
            }]
        }, 
        {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            style: {
                marginTop: '5px',
                marginLeft: '10px',
            },
            items: [{
                xtype: 'displayfield',
                name: 'offerLetterMessage2',
                itemId: 'offerLetterMessage2',
                style: {
                    height: 'auto',
                    textAlign: 'justify'
                },
                flex: 1,
                value: '<p style=\'font: normal 13px/17px Open Sans, sans-serif, Myriad Pro;margin:0px 0px;\'>' + getAdmissionTranslation('APOL_ACCEPT_OFFER_LETTER_WIN_MESSAGE2') + '</p>',
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            cls: 'windowBtnPos',
            style: {
                marginTop: '10px',
                marginLeft: '8px'
            },
            items: [{
                xtype: 'button',
                text: getAdmissionTranslation('APOL_ACCEPT'),
                itemId: 'acceptAcceptOfferLetterWinItemId',
                buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                formBind: true,
                disabled: true,
                scale: CONSTANTS.BUTTONSIZE
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'cancelAcceptOfferLetterWinItemId',
                buttonAlign: 'left',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});