/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show list of application programs in Dialog box.
 * 
 */
Ext.define('Academia.view.admission.applications.applicantProfileBase.ApproveRejectWithdrawApplicationWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.approverejectwithdrawapplicationwindow',
    modal: true,
    autoScroll: true,
    applicationType: '',
    resizable: false,
    height: (Ext.isIE8) ? 600 : '65%',
    width: (Ext.isIE8) ? 500 : '65%',
    title: getAdmissionTranslation('APPLICATION_PROGRAMS'), //Application Programs							    
    items: [],
    initComponent: function() {
        var this$ = this;
        var itemArray=new Array();                
        
            if (!isNullOrEmpty(this$.applicationType) && this.applicationType === 'APPROVE') {            	
            	var approveApplicationTypePanel=this$.getApproveApplicationTypePanel();                	
            	var buttonsPanel=this$.getButtonsPanel();                	
            	itemArray=approveApplicationTypePanel.concat(buttonsPanel);
            	this$.items=itemArray;            	
            } else if (!isNullOrEmpty(this$.applicationType) && this.applicationType === 'REJECT') {
            	var rejectApplicationTypePanel=this$.getRejectApplicationTypePanel();                	
            	var buttonsPanel=this$.getButtonsPanel();                	
            	itemArray=rejectApplicationTypePanel.concat(buttonsPanel);
            	this$.items=itemArray;            	            	
            } else if (!isNullOrEmpty(this$.applicationType) && this.applicationType === 'WITHDRAW') {
            	var withdrawApplicationTypePanel=this$.getWithdrawApplicationTypePanel();                	
            	var buttonsPanel=this$.getButtonsPanel();                	
            	itemArray=withdrawApplicationTypePanel.concat(buttonsPanel);
            	this$.items=itemArray;            	            	
            }
            this$.doLayout();        
            this.callParent(arguments);            
    },
    getButtonsPanel:function(){
    	var itemArray=new Array();
    	itemArray.push({
    		xtype : 'fieldcontainer',
        	width: '100%',
    		cls : 'windowBtnPos',
    		style :{marginLeft: '17px'},
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SUBMIT'), //Submit
                itemId: 'submitBtn',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                hasDisableForProfileViewMode:true,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'), //Cancel
                action: 'cancel',
                ui: 'CustomBtnCancel',
                itemId: 'cancelBtn',
                scale: CONSTANTS.BUTTONSIZE
            }]
        });
    	return itemArray;
    },
    getApproveApplicationTypePanel:function(){
    	var itemArray=new Array();
    	itemArray.push({
            xtype: 'approveapplicationprogramform',
            itemId: 'applicationProgramForm'
        });
    	return itemArray;
    },
    getRejectApplicationTypePanel:function(){
    	var itemArray=new Array();
    	itemArray.push({
            xtype: 'form',
            plugins : "formlabelrequired",
            itemId: 'applicationProgramForm',
            items: [{
            	xtype: 'hidden',
            	name:'applicationId',
                itemId: 'hiddenApplicationId'
            },{
            	xtype: 'hidden',
            	name:'currentStatus',
                itemId: 'hiddenCurrentStatus'
            },{
                xtype: 'applicationprogramgrid',
                itemId: 'applicationProgramGrid'
            },{
                xtype: 'customcombobox',
                name: 'reasonId',
                itemId: 'cmbRejectReason',
                fieldLabel: getAdmissionTranslation('REASON_FOR_REJECTION'), //Reason for Rejection
                 //Reason for Rejection
                store: 'admission.applications.applicantProfileBase.ReasonsForRejectionComboStore',
                valueField: 'id',
                displayField: 'value',
                editable: false,
                width: 226,
                style: {
                    marginLeft: '10px'
                },
                labelAlign: 'top',
                //queryMode: 'local',
                allowBlank: false
            }, {
                xtype: 'textareafield',
                name: 'remark',
                fieldLabel: getAdmissionTranslation('REJECTION_REMARKS'), //Rejection Remarks
                 //Rejection Remarks		            
                labelAlign: 'top',
                width: 226,
                style: {
                    marginLeft: '10px'
                },
                maxLength: 250
            }]
        });
    	return itemArray;
    },
    getWithdrawApplicationTypePanel:function(){
    	var itemArray=new Array();
    	itemArray.push({
            xtype: 'form',
            plugins : "formlabelrequired",
            itemId: 'applicationProgramForm',
            items: [{
            	xtype: 'hidden',
            	name:'applicationId',
                itemId: 'hiddenApplicationId'
            },{
            	xtype: 'hidden',
            	name:'currentStatus',
                itemId: 'hiddenCurrentStatus'
            },{
                xtype: 'applicationprogramgrid',
                itemId: 'applicationProgramGrid'
            },{
                xtype: 'customcombobox',
                name: 'reasonId',
                itemId: 'cmbWithdrawalReason',
                fieldLabel: getAdmissionTranslation('REASON_FOR_WITHDRAWAL'), //Reason for Withdrawal
                 //Reason for Withdrawal
                store: 'admission.applications.applicantProfileBase.ReasonsForWithdrawalComboStore',
                valueField: 'id',
                displayField: 'value',
                editable: false,
                width: 226,
                style: {
                    marginLeft: '10px'
                },
                labelAlign: 'top',
                //queryMode: 'local',
                allowBlank: false
            }, {
                xtype: 'textareafield',
                name: 'remark',
                fieldLabel: getAdmissionTranslation('WITHDRAWAL_REMARKS'), //Withdrawal Remarks
                 //Withdrawal Remarks		            
                labelAlign: 'top',
                width: 226,
                style: {
                    marginLeft: '10px'
                },
                maxLength: 250
            }]
        });
    	return itemArray;
    }
});