/**
 * @author Vyabha Thakur
 */
Ext.define('Academia.view.admission.applications.applicantProfileBase.DocumentAndNotesDocumentGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.documentandnotesdocumentgrid',
    store : 'admission.applications.applicantProfileBase.DocumentAndNotesDocumentGridStore',
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar: [{
        xtype: 'button',
        itemId: 'btnEdit',
		disabled:true,
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    },{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH		
	}],
	columns :[{
		header : getCommonTranslation('DOCMENT_NAME'),
		dataIndex : 'documentName',
		flex:1,
		renderer:function(value,rec){
		    var value1=!isNullOrEmpty(value)?value:rec.record.data.name;
            var newPath=rec.record.data.path;    
            var val=!isNullOrEmpty(value1)?value1:newPath;
            return "<a href='#'>"+val;
		}
	}]
});

