/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.admission.applications.applicationBase.PandaDocPopup', {
	extend: 'Ext.window.Window',
	alias: 'widget.pandadocpopup',
	modal: true,
	overflowX:'hidden',
	overflowY:'auto',
	height:'60%',
	width: '75%',
	title: getAdmissionTranslation('PANDADOC'),
	layout: 'vbox',
	defaults: {
		width: '100%'
	},
	items: [{
		xtype: 'idgeneratorformwin',
		plugins:"formlabelrequired",
		layout: 'vbox',
		style:{
			marginBottom:'0px'
		},
		items: [{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('SELECT_TEMPLATE'),
				name: 'templateId',
				itemId: 'templateId',
				store: 'admission.applications.pandadoc.PandaDocTemplateStore',
				valueField: 'id',
				displayField: 'name',
				typeAhead:false,
				allowBlank: false,
				forceSelection:true,
				width: 226,
				editable: false
			},{
				xtype: 'textfield',
				fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_PERCENTAGE'),
				name: 'discount',
				itemId: 'discount',
				width: 226,
				enforceMaxLength:true,
	            maskRe: /[0-9.-]/,
	            enforceMaxLength:true,
	            maxLength:50
			},{
				xtype: 'datefield',
				name: 'discountValidationStartDuration',
				itemId:'discountValidationStartDuration',
				endDateField:'discountValidationEndDuration',
				vtype: 'daterange',
				width: 226,
//				value:new Date(),
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				fieldLabel:getCommonTranslation('DISCOUNT_VALIDATION_START_DATE'),
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			},{
				xtype: 'datefield',
				name: 'discountValidationEndDuration',
				itemId:'discountValidationEndDuration',
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				fieldLabel:getCommonTranslation('DISCOUNT_VALIDATION_END_DATE'),
				vtype: 'daterange',
				width: 226,
				minValue:new Date(new Date().setDate(new Date().getDate()+1)),
				startDateField: 'discountValidationStartDuration',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getCommonTranslation('TUTION_PAYMENT_USD'),
				name: 'tutionPayment',
				itemId: 'tutionPayment',
				width: 226,
	            maskRe: /[0-9.-]/,
	            enforceMaxLength:true,
	            maxLength:50
			}, {
				xtype : 'textfield',
				name : 'cf1',
				width: 226,
				itemId:'cf1',
				fieldLabel : getCommonTranslation("CF1")
			}, {
				xtype : 'textfield',
				name : 'cf2',
				itemId:'cf2',
				width: 226,
				fieldLabel : getCommonTranslation("CF2")
			},{
				xtype: 'button',
				text: getAdmissionTranslation('SEND_NOW'),
				itemId: 'sendNowBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				margin: '30 0 0 8',
				formBind: true
			}, {
				xtype: 'button',
				text: getAdmissionTranslation('SEND_LATER'),
				action: 'cancel',
				ui: 'CustomBtnCancel',
				itemId: 'sendLaterBtn',
				scale: CONSTANTS.BUTTONSIZE,
				margin: '30 0 0 8',
				formBind: true
			}]
		}]
	}, {
		xtype: 'grid',
		itemId: 'pandadocGrid',
		title: getAdmissionTranslation('LIST_OF_PANDA_DOC'),
		store: 'admission.applications.pandadoc.PandaDocGridStore',
		margin: '16 10 32 10',
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		border: true,
		flex: 1,
		columns: [{
			header: getCommonTranslation('S_NO'),
			xtype: 'rownumberer',
			align: 'left',
			flex: .2
		}, {
			header: getAdmissionTranslation('DOCUMENT_NAME'),
			dataIndex: 'documentName',
			sortable: true,
			flex: 2,
			renderer:function(value,meta,record) {
	        	if(!isNullOrEmpty(value)) {
	        		return '<a href="#">'+value+'</a>';
				}
	        }
		}, {
			header: getAdmissionTranslation('SEND_DATE'),
			dataIndex: 'sendDate',
			sortable: true,
			flex: 1,
			renderer: function(date) {
	            return dateRender(date);
	        }
		}, {
			header: getCommonTranslation('SIGNED_DATE'),
			dataIndex: 'signedDate',
			sortable: true,
			flex: 1,
			renderer: function(date) {
	            return dateRender(date);
	        }
		}, {
			header: getCommonTranslation('STATUS'),
			dataIndex: 'docStatus',
			sortable: true,
			flex: .5
		}, /*{
			header: getCommonTranslation('ACTION'),
			dataIndex: 'deleteButton',
			flex: 1,
			style:{'text-align':'center'},
			sortable: false,
			renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
				  if(record.data.linkedRecord){
						 var linkBtn ='<button class="x-btn x-unselectable x-btn-CustomBtnCancel-small x-noicon x-btn-noicon x-btn-CustomBtnCancel-small-noicon" type="button" style="margin-left: 45px !important">' +getCommonTranslation('DELETE')+'</button>';
						 return linkBtn;
					
					
				}else{
					return '';
				}
			}
		}, {
			dataIndex: 'sendButton',
			flex: 1,
			style:{'text-align':'center'},
			sortable: false,
			renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
				  if(record.data.linkedRecord){
						 var linkBtn ='<button class="x-btn x-unselectable x-btn-CustomBtnCancel-small x-noicon x-btn-noicon x-btn-CustomBtnCancel-small-noicon" type="button" style="margin-left: 45px !important">' +getAdmissionTranslation('SEND')+'</button>';
						 return linkBtn;
					
					
				}else{
					return '';
				}
			}
		},*/ {
	           text: getCommonTranslation('DELETE'),
	           align: 'center',
	           width: 90,
	           dataIndex: 'delete',
	           renderer: function(val,meta,rec) {
	               // generate unique id for an element
	               var id = Ext.id();
	               Ext.defer(function() {
	                  Ext.widget('button', {
	                     renderTo: Ext.query("#"+id)[0],
	                     text: getCommonTranslation('DELETE'),
	                     action: 'cancel',
	                     itemId: 'deletePandaDoc',
	     				ui: 'CustomBtnCancel',
	     				//itemId: 'sendLaterBtn',
	     				scale: CONSTANTS.BUTTONSIZE
	                  });
	               }, 50);
	               return Ext.String.format('<div id="{0}"></div>', id);
	            }
	       }, {
	           text: getAdmissionTranslation('SEND'),
	           align: 'center',
	           width: 90,
	           dataIndex: 'send',
	           renderer: function(val,meta,rec) {
	               // generate unique id for an element
	        	   var btnHide = true;
	        	   if(rec.get('docStatus') == 'draft') {
	        		   btnHide = false;
	        	   }
	               var id = Ext.id();
	               Ext.defer(function() {
	                  Ext.widget('button', {
	                     renderTo: Ext.query("#"+id)[0],
	                     text: getAdmissionTranslation('SEND'),
	                     action: 'cancel',
	                     itemId: 'sendPandaDoc',
	     				ui: 'CustomBtnCancel',
	     				//itemId: 'sendLaterBtn',
	     				scale: CONSTANTS.BUTTONSIZE,
	     				hidden: btnHide
	                  });
	               }, 50);
	               return Ext.String.format('<div id="{0}"></div>', id);
	            }
	       }]
	}]
});
