/**
 *  @author <a href="mailto:vidhi.shah@serosoft.in">Vidhi Shah</a>
 */

Ext.define('Academia.view.admission.applications.applicationBase.ReassignEscalationForm', {
	extend: 'Ext.window.Window',
	alias: 'widget.reassignescalationform',
	autoScroll: true,
	title:getCommonTranslation('REASSIGN_ESCALATION'),
	modal:true,
	frame: true,
	items: [{
		xtype: 'idgeneratorformwin',

		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'

		},
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{  
				xtype: 'customcombobox',
				name: 'assignedTo',
				itemId:'assignedToItemId',
				store: Ext.create('Academia.store.common.AssignReviewersToApplicationsStore'),
				fieldLabel: getCommonTranslation('ESCALATION_REASSIGN_USER'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'qry',
				minChars:3,
				editable:true,
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				allowBlank:false,
				listConfig: {
				 listeners: {
					 beforeshow: function(picker) {
						 picker.minWidth = picker.up('combobox').getSize().width;
					 }
				 },
				 loadingText: getCommonTranslation('SEARCHING'),
				 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				 getInnerTpl: function() {
					 return '<div class="search-item">' +
					 '{value}'+
					 '</div>';
				 }
				}
			 },{
				xtype: 'datefield',
				name: 'reassignOwnerdate',
				itemId: 'reassignOwnerdateItemId',
				fieldLabel: getCommonTranslation('ESCALATION_REASSIGN_DATE'),
				listeners: {
					render: function(field) {
						dateFormatRender(field);
						field.setValue(new Date());
					}
				}
			},
			]
		},{
			xtype: 'fieldcontainer',
			layout: 'vbox',
			defaults: {
				labelAlign: 'top',
				width: 460
			},
			items: [{
				xtype: 'textarea',
				name: 'reassignOwnerRemark',
				itemId: 'reassignOwnerRemarkItemId',
				fieldLabel: getCommonTranslation('ESCALATION_REASSIGN_REASON'),
				maxLength: 250,
				maskRe:/^[a-zA-Z0-9\s]+$/
			}]
		},
		{
			border : false,

			layout : {
				type : 'hbox',
				width : '100%'
			},
			style:{
				marginLeft:'0px'
			},
			items: [{

				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'reassignEscalationSubmitButtonId',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			}, {	
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId:'reassignEscalationCancelButtonId',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});