Ext.define('Academia.view.admission.selectionStage.ChangeStatusPoppupWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.changeStatusPoppupWindow',
    title: getAdmissionTranslation('PROGRAM_SELECTION_STAGE_STATUS'),
    autoScroll: true,
    maxHeight: 600,
    modal: true,
    items: [{
        xtype: 'form',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        plugins: "formlabelrequired",
        items: [{
            xtype: 'hidden',
            name: 'applicationProgramStageId'
        }, {
            xtype: 'customcombobox',
            fieldLabel: getAdmissionTranslation('MODIFY_STATUS'),
            name: 'status',
            itemId: 'status',
            store: 'admission.selectionStage.ApplicationProgramStageStatusStore',
            valueField: 'value',
            displayField: 'name',
            allowBlank: false,
            editable: false
        }, {
            xtype: 'nestedJsonCombo',
            fieldLabel: getAdmissionTranslation('UNSUCCESSFUL_REASON'),
            name: 'unsuccessfulReason',
            itemId: 'unsuccessfulReason',
            store: 'admission.selectionStage.UnsuccessfulReasonStore',
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            editable: false,
            hidden : true
        }, {
            xtype: 'datefield',
            name: 'approvedDate',
            allowBlank: false,
            editable: false,
//            value : new Date(),
//            maxValue: new Date(),
//            format: CONSTANTS.DATE_FORMAT,
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            fieldLabel: getCommonTranslation('APPROVED_DATE'),
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setMaxValue(new Date());						
					obj.setValue(new Date());
				}
			}
        }, {
            xtype: 'textareafield',
            name: 'remark',
            fieldLabel: getCommonTranslation('Remark')
        }, {
            xtype: 'nestedTextField',
            itemId: 'approvedByNestedTextField',
            name: 'approvedBy',
            displayField: 'value',
            fieldLabel: getCommonTranslation('APPROVER')
        },{
            xtype: 'fieldcontainer',
            width: '100%',
    		cls : 'windowBtnPos',
    		style :{marginLeft: '-1px',marginTop:'10px'},
    		items: [{
            	xtype: 'button',
                itemId: 'formSubmitButtonId',
                action: 'Submit',
                text: getCommonTranslation('SUBMIT'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true,
                disabled: true
            },{
            	xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                action: 'Cancel',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});