/**
 * @author Amit G
 */
Ext.define('Academia.view.admission.selectionStageReport.SelectionStageReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.selectionstagereportgrid',
	store: 'admission.selectionStageReport.SelectionStageReportGridStore',
	title: getAdmissionTranslation('SELECTION_STAGE_MARK_ENTRY_LIST'),
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'admission.selectionStageReport.SelectionStageReportGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: ['->',{
		xtype: 'button',
		text:getCommonTranslation('EXPORTREPORTS'),
		itemId:'exportReportsId',
		tooltip :getCommonTranslation('EXPORTREPORTS'),
		disabled:true,
	}],
	columns: [{
		header:  getCommonTranslation('APPLICATION_ID'),
		dataIndex: 'applicantCode',
		flex:.1
	},{
		header:  getAdmissionTranslation('APPLICATION_NAME'),
		dataIndex: 'printName',
		flex:.1
	},{
		header:  getAdmissionTranslation('SELECTION_STAGE_NAME'),
		dataIndex: 'selectionStageName',
		flex:.1
	},{
		header:  getCommonTranslation('TOTAL_MARKS_GRID'),
		dataIndex: 'stageEffectiveMarks',
		flex:.1
	},{
		header:  getCommonTranslation('EFFECTIVE_MARKS_GRID'),
		dataIndex: 'stageEffectiveMarks',
		flex:.1
	},{
		header:  getCommonTranslation('RANK'),
		dataIndex: 'rank',
		flex:.1
	},{
		header:  getCommonTranslation('CURRENT_STATUS'),
		dataIndex: 'currentStatus',
		flex:.1
     },{
		header:  getCommonTranslation('Remark'),
		dataIndex: 'remark',
		flex:.1
	}]
});
