/**
 * Personal Information Form 
 * @author Niklesh
 */
Ext.define('Academia.view.alumniSystem.alumniList.AlumniPersonalInformationForm', {
	extend :'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.alumnipersonalinformationform',
	cls:'alumnipersonalinformationform',
	padding: '15',
	margin: 0,
	autoScroll:true,
	plugins:"formlabelrequired",
	defaults: {
		labelAlign: 'top',		
	},
	items : [{
		xtype: 'fieldcontainer',
		layout: {
			type : 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'textfield',
			itemId : 'alumniCode',
			fieldLabel: getAlumni('ALUMNI_ID'),                
			name: 'alumniCode',
			allowBlank: false,
			readOnly:true
		},{
			xtype: 'textfield',
			itemId : 'studentId',
			fieldLabel: getAlumni('STUDENT_ID'),                
			name: 'studentId',	
			allowBlank: false,
			readOnly:false,
			maxLength:100,
		},{
			xtype: 'textfield',
			itemId : 'admissionId',
			fieldLabel: getAlumni('ADMISSION_ID'),                
			name: 'admissionId',	
			allowBlank: false,
			readOnly:false,
			maxLength:100,
		},
//		{
//			xtype: 'photouploadform',
//			itemId: 'alumniPhotoUploadForm',	
//			name: 'alumniPhotoUploadForm',		
//			width:320,
//			style:{
//        		marginTop: '-3px!important'
//        	},
//		}
		]
	},
		{
			xtype: 'fieldcontainer',
			layout: {
				type : 'hbox'
			},
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'nestedJsonCombo',
				fieldLabel: getAlumni('SALUTATION'),
				itemId:'salutation',
				name: 'salutation',
				store: 'common.SalutationStore',
				valueField: 'id',
				displayField: 'salutationName',
				allowBlank: false,
				editable: false
			},{
				xtype: 'textfield',
				fieldLabel: getAlumni('PERSON_FIRST_NAME'),
				name: 'firstName',
				itemId:'firstName',
				allowBlank: false,
				maxLength:100,
			}, {
				xtype: 'textfield',
				fieldLabel: getAlumni('PERSON_MIDDLE_NAME'),
				name: 'middleName',
				itemId:'middleName',
				maxLength:100,
			},{
				xtype: 'textfield',
				fieldLabel: getAlumni('PERSON_LAST_NAME'),
				name: 'lastName',
				itemId: 'lastName',
				allowBlank: false,
				maxLength:100,
			}]
		},{
			xtype: 'fieldcontainer',
			layout: {
				type : 'hbox'
			},
			defaults: {
				
				labelAlign: 'top'
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getAlumni('PERSON_PRINT_NAME'),
				name: 'printName',
				itemId: 'printName',
				width: 226,
				readOnly:true
			},{
               xtype: 'textfield',
                fieldLabel: getAlumni('EMAIL_ID'), 
               name: 'emailId',
               itemId: 'emailId',
               vtype: 'multiemail',
               allowBlank: false,
               maxLength:100,
           		width: 226
           }, {
				xtype: 'fieldcontainer',
				itemId : 'mobileNoFldItemId',
				fieldLabel: getAlumni('MOBILE_NO'),
				layout : {
					type : 'hbox'
				},
				allowBlank: false,
				// width: 320,
				items : [ {
					xtype : 'customcombobox',
					name : 'phoneCountryCode',
					itemId : 'phoneCountryCode',
					valueField : 'isdCode',
					displayField : 'isdCode',
					store:'common.CountryStore',
					triggerAction : 'all',
					//editable : false,
					forceSelection:true,
					width: 65,
					minChars: 1,
					listeners:{
						change : function(obj,value){
						var form = obj.up();
						countryCodeField = form.down('#phoneCountryCode');
						mobileField = form.down('#mobileNumber');
						countryCodeField.getStore().load({
		        			callback: function(records, operation, success) {
		        				if (success) {
		        						var countryCode = value;
		            					for(var i in records){
		            						if(records[i].data.isdCode == countryCode){
		        								countryInfo = records[i].data;
		        								mobileField.maxLength = (!isNullOrEmpty(countryInfo.maximumDigit)) ? parseInt(countryInfo.maximumDigit) : 0;
		        								mobileField.minLength = (!isNullOrEmpty(countryInfo.minimumDigit)) ? parseInt(countryInfo.minimumDigit) : 10;
		        								if(!isNullOrEmpty(mobileField.getValue())) {
		        									mobileField.isValid();
		        									try{
		        				        				form.getForm().checkValidity();
		        				        	 		}
		        				        	 		catch(e){}
		        								}
		        								break;
		        							}
		            					}
		        				}
		        			}
		        		});
						}
					}
				}, {
					xtype : 'numberfield',
					name : 'mobileNumber',
					itemId : 'mobileNumber',
					enforceMaxLength : true,
					// To Remove spinner buttons, and arrow key and mouse wheel listeners
					hideTrigger: true,
					keyNavEnabled: false,
					allowBlank: false,
					mouseWheelEnabled: false,
					allowExponential:false,
					width : 150
				}]
			}]
			},
			{
				xtype: 'fieldcontainer',
				layout: {
					type : 'hbox'
				},
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
						xtype: 'nestedJsonCombo',
						fieldLabel: getAlumni('GENDER'),
						itemId: 'gender',
						name: 'gender',
						valueField: 'code',
						displayField: 'value',
						store: 'common.GenderTypeStore',
						editable: false,
						allowBlank: false
					},{
						xtype: 'datefield',
						fieldLabel: getAlumni('DATE_OF_BIRTH'),
						itemId: 'birthDate',
						name: 'birthDate',
						maxValue: new Date(),	
						allowBlank: false,
						format: 'DD/MM/YYYY',
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						}
				},{
					xtype: 'customcombobox',
					fieldLabel: getAlumni('STATUS'),
					itemId: 'statusAlumniId',
					name: 'statusALumni',
					store: Ext.create('Academia.store.alumni.alumniList.AlumniStatusStore'),
					displayField: 'value',
					valueField: 'value',
					editable: false,
			}]
			},{
				 items: [{
			        	xtype:'fieldcontainer',
			        	width:'100%',
			        	style:{
			        		marginLeft: '0px'
			        	},
			            items: [{
			                xtype: 'button',
			                text: getCommonTranslation('SAVE'),
			                itemId: 'submitButtonId',
			                buttonAlign: 'right',
			                ui: 'CustomBtnSubmit',
			                scale: CONSTANTS.BUTTONSIZE,
			                formBind : true
			            }]
			        }]
			}	
	]
	
});
