/**
 *  @author Niklesh Tiwane
 */

Ext.define('Academia.view.alumniSystem.alumniList.alumniListGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.alumniListGrid',
    store: 'alumni.alumniList.AlumniListStore',
    title: getAlumni('ALUMNI_LIST'),
    selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		//checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
    border: true,
    refreshStoreData: true,
    isGridConfigurable: true,
    enableColumnHide: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    headerFix: {
        headerFix: true,
        portalIdsWithStructure: {
            'alumniListStructure':1
        }
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'alumni.alumniList.AlumniListStore',
            emptyMsg: getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: [{
        xtype: 'button',
        itemId: 'resetPasswordId',
        tooltip: getAlumni('RESET_PASSWORD'),
        text: getAlumni('RESET_PASSWORD'),
        disabled: true
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        tooltip: getAlumni('DELETE'),
        text: getAlumni('DELETE'),
        disabled: true
    },'->'],
    columns: [{
        header: getCommonTranslation('ALUMNI_ID'),
        dataIndex: 'alumniCode',
        flex: 1,
        renderer : function(value){
			if( !isNullOrEmpty(value) && value != 0 ){
				return  '<a href="#">'+value+'</a>';
			} else {
				return  value;
			}
		}
    }, {
        header: getAlumni('STUDENT_ID'),
        dataIndex: 'studentCode',
        flex: 1
    },{
        header: getCommonTranslation('ALUMNI_NAME'),
        dataIndex: 'alumniName',
        flex: 1,
    }, {
        header: getAlumni('MOBILE_NO'),
        dataIndex: 'mobileNumber',
        flex: 1
    },{
        header: getAlumni('EMAIL_ID'),
        dataIndex: 'emailId',
        flex: 1,
    },{
		header : getCommonTranslation('GENDER'),
		dataIndex : 'gender',
		flex:1,
		renderer:function(value, meta, record){
            if(value=="MALE"){
                  return "Male";
            }else if(value=="FEMALE"){
	               return "Female";
            }else {
	              return "Other";
            }
         }
	},{
        header: getAlumni('DATE_OF_BIRTH'),
        dataIndex: 'alumniDateOfBirth',
        flex: 1
    }, {
        header: getAlumni('ACADEMY_LOCATION'),
        dataIndex: 'academyLocationName',
        flex: 1,
    },{
        header: getAlumni('PROGRAM'), 
        dataIndex: 'programName',
        flex: 1,
    }, {
        header: getAlumni('BATCH'),
        dataIndex: 'batchName',
        flex: 1,
    },{
        header: getCommonTranslation('PASSOUT_YEAR'),
        dataIndex: 'passOutYear',
        flex: 1,
    }]
});
