/**
 *  @author Niklesh Tiwane
 */
Ext.define('Academia.view.alumniSystem.signUpRequest.SignUpRequestGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.signUpRequestGrid',
	title: getAlumni('SIGN_UP_REQUEST'),
	store : 'alumni.signUpRequest.SignUpRequestStore',
	selType:'checkboxmodel',
	itemId: 'signUpRequestGridItemId',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		//checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	headerFix: {
    	headerFix: true,
    	portalIdsWithStructure: {
			'signUpRequestStructure':1
		}
    },
	border: true,
	refreshStoreData: true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'alumni.signUpRequest.SignUpRequestStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true,
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments); 
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon',
		disabled:true
	},{
		xtype: 'button',
		itemId: 'btnManageRequest',
		text: getAlumni('MANAGE_REQUEST'),
		disabled:true
	},{
		xtype: 'button',
		itemId: 'btnAutoApprove',
		text: getAlumni('APPROVE_ALL'),
		disabled:true
	},'->'],
	columns: [{
		header : getCommonTranslation('SIGNUP_REQUEST_ID'),
		dataIndex : 'signupCode',
		flex:1,
		renderer : function(value, alS, status){
			if( !isNullOrEmpty(value) && value != 0 && status.data.alumniStatus !== "APPROVED"){
				return  '<a href="#">'+value+'</a>';
			} else {
				return  value;
			}
		}
	},{
		header : getCommonTranslation('ALUMNI_NAME'),
		dataIndex : 'alumniName',
		flex:1
	},{
		header : getAlumni('MOBILE_NUMBER'),
		dataIndex : 'mobileNumber',
		flex:1
	},{
		header : getAlumni('EMAIL_ID'),
		dataIndex : 'emailId',
		flex:1
	},{
		header : getAlumni('GENDER'),
		dataIndex : 'gender',
		flex:1,
		renderer:function(value, meta, record){
            if(value=="MALE"){
                  return "Male";
            }else if(value=="FEMALE"){
	               return "Female";
            }else {
	              return "Other";
            }
         }
	},{
		header : getAlumni('DATE_OF_BIRTH'),
		dataIndex : 'alumniDateOfBirth',
		flex:1
	},{
		header : getAlumni('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex:1
	},{
		header : getAlumni('PROGRAM'),
		dataIndex : 'programName',
		flex:1,
		renderer:function(value, meta, record){
            if(value==null){
                  return "Other Program";
            }else{
	               return value;
            }
         }
	},{
		header : getAlumni('BATCH'),
		dataIndex : 'batchName',
		flex:1,
		renderer:function(value, meta, record){
            if(value==null){
                  return "Other Batch";
            }else{
	               return value;
            }
         }
	},{
		header : getCommonTranslation('PASSOUT_YEAR'),
		dataIndex : 'passOutYear',
		flex:1
	},{
		header : getAlumni('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex:1
	},{
		header : getAlumni('ADMISSION_ID'),
		dataIndex : 'admissionCode',
		flex:1
	},{
		header : getAlumni('STATUS'),
		dataIndex : 'alumniStatus',
		flex:1,
		renderer:function(value, meta, record){
            if(!isNullOrEmpty(value)) {
                if(value=="APPROVED")
                    {
                		return getAlumni('APPROVED');
                    }
                else if(value =="REJECTED")
                	{
                	  return getAlumni('REJECTED');
                	}
                else{
                	 return getAlumni('PENDING');
                }
            }       
        }
	},{
		header : getAlumni('REMARKS'),
		dataIndex : 'reason',
		flex:1
	},{
		header : getAlumni('DOCUMENTS'),
		dataIndex : 'documentURL',
		flex:1,
		renderer : function(value){
			if( !isNullOrEmpty(value) && value != 0 ){
				return  '<a href="#">Click here</a>';
			} else {
				return  value;
			}
		}
	}]
});