/**
 * @author Vidhi Shah
 */
Ext.define('Academia.view.applicantportalsetup.DashboardUploadDocumentList', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.dashboarduploaddocumentlist',
    store : 'applicantPortalSetup.DashboardGuidelinesDocumentListStore',
    title: getHostelTranslation('UPLOAD_GUIDELINE_DOCUMENT'),
    border: true,
    autoScroll: true,
    columnLines : true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    cls:'centerAlignTitle',
	tbar: [{
        xtype: 'button',
        itemId: 'deleteGuidelineDocument',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    },
    {
        xtype: 'button',
        itemId: 'addGuidelineDocument',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }],
    
    columns: [{
        header: getDocumentTranslation('DOCUMENT_NAME'),
        dataIndex: 'documentName',
        align: 'left',
        sortable: false,
        flex: 1,
    	renderer:function(value,rec){
			if(value){
				return "<a href='#'>"+value+"</a>";
			}
		}
    }]
});