Ext.define('Academia.view.applicantportalsetup.VWAdmApplicantPortalSetUpGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.vwadmapplicantportalsetupgrid',	
	store:'applicantPortalSetup.stoAdmApplicantPortalSetUpGrid', 
	border: true,
	title:getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'),
	autoScroll: false,
	refreshStoreData:true,
	frame:false,
	style: {
		'position': 'relative !important'
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar:[{
		xtype:'button',
		text:getCommonTranslation('SAVE'),
		action:'save',
		itemId:'btnSavePrivilege'
	}],	
	columns:[{
		header:getCommonTranslation('MODULE_NAME'),
		dataIndex:'moduleName',
		flex:0.1,
		sortable:false,
		renderer:function(value) {
			return getPortalSetupNew(value);
		}	
	},{
		xtype:'checkcolumn',
		header:getCommonTranslation('MODULE_VISIBILITY'),
		flex:.1,
		sortable:false,
		dataIndex : 'visibility',
		renderer: function(value, metadata,record) {
			var data=record.data;
			if(data.moduleCode != 'STEP4_PROGRAM_DETAILS' && data.moduleCode != 'STEP10_DECLARATION_N_PAYMENTS' && data.moduleCode != 'STEP36_DASHBOARD'){
				var cssPrefix = Ext.baseCSSPrefix,
				cls = cssPrefix + 'grid-checkcolumn';
				if (value) {
					cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
				}
				return '<img class="' + cls + '" src="' + Ext.BLANK_IMAGE_URL + '"/>';
			}
		}			
	},{
		xtype:'checkcolumn',
		flex:.1,
		sortable:false,
		header:getCommonTranslation('MODULE_MANDATORY'),
		dataIndex : 'mandatory'	,
		renderer: function(value, metadata,record) {
			var data=record.data;
			if(data.moduleCode != 'STEP4_PROGRAM_DETAILS' &&  
					data.moduleCode != 'STEP10_DECLARATION_N_PAYMENTS' && data.moduleCode != 'STEP20_PAYMENTS' && data.moduleCode != 'STEP35_DOCUMENT_REQUEST' &&
					data.moduleCode != 'STEP36_DASHBOARD'){
				var disabled=!data.visibility;
				if(disabled){
					metadata.style+= ' opacity:0.3';
					value=data.mandatory;
				}

				var cssPrefix = Ext.baseCSSPrefix,
				cls = cssPrefix + 'grid-checkcolumn';
				if (value) {
					cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
				}
				return '<img class="' + cls + '" src="' + Ext.BLANK_IMAGE_URL + '"/>';
			}
		},
		processEvent: function(type, view, cell, recordIndex, cellIndex, e) {
			if (type == 'mousedown' || (type == 'keydown' && (e.getKey() == e.ENTER || e.getKey() == e.SPACE))) {
				var record = view.panel.store.getAt(recordIndex);
				var data=record.data;
				var disabled=!data.visibility;
				//do not change data and fire checkchange event if it's disabled
				view.focusRow(recordIndex);
				if (!disabled) {
					dataIndex = this.dataIndex;
					checked = !record.get(dataIndex);
					record.set(dataIndex, checked);
					this.fireEvent('checkchange', this, recordIndex, checked);
				}
				return false;
			}
		}	
	},{
		header:getCommonTranslation('MODULE_SEQUENCE'),
		flex:.05,
		sortable:false,
		dataIndex : 'sequenceNo',
		style: {
			'text-align': 'center'
		},
		editor: {
			xtype: 'numberfield',
			name: 'sequenceNo',
			minValue:0,
			maxLength: 6,
			width: 12,
			enforceMaxLength : true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowDecimals:false,
			style: {
				margin: 'auto'
			},
			//style:{'width':'40% !important','border':'1px solid #000'},
			itemId: 'sequenceNoItemId'
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			var data=record.data;
			if(data.moduleCode != 'STEP4_PROGRAM_DETAILS' && data.moduleCode != 'STEP10_DECLARATION_N_PAYMENTS' && data.moduleCode != 'STEP36_DASHBOARD' ){
				if(!isNullOrEmpty(value) && value !== '') {
					try{
						rec.tdCls = 'gridInputCustomStyleForSqeuence';
						return value;
					}
					catch(e){
						return null;
					}
				}
				else {
					rec.tdCls = 'gridInputCustomStyleForSqeuence';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
			}
		}			
	},
	{
		header:getCommonTranslation('LOCK_AFTER_APPLICATION_STATUS'),
		flex:0.1,
		sortable:false,
		dataIndex : 'appPortalApplicationStatus',
		style: {
			'text-align': 'center'
		},
		editor: {
			xtype: 'multiselectcombofield',
			name: 'lockAfterApplicationStatus',
			itemId: 'lockAfterApplicationStatus',      
			store: 'applicantPortalSetup.AppPortalApplicationStatusStore',
			valueField: 'id',
			displayField: 'value',		
			allowBlank: true,
			typeAhead:true,
			forceSelection:true,
			cls:'commonAutoHeightMultiselectField'
		},
		renderer:function(value,meta,record,store){
			if(!isNullOrEmpty(value)) {
				var obj = [];
				if(!isNullOrEmpty(record.data.appPortalApplicationStatus.length) && !isNullOrEmpty(record.data.appPortalApplicationStatus[0])){
					for(var j=0;j<record.data.appPortalApplicationStatus.length;j++){
						var mode=record.data.appPortalApplicationStatus[j];
						if(!isNullOrEmpty(mode.applicationStatus)){
							var tranValue = getCommonTranslation(mode.applicationStatus);
							obj.push(tranValue);
							
						}else{
							valData = '\n' + mode.data.value +'\n';
							obj.push(valData);
						}
					}	
					return obj;
				}else{
					meta.tdCls = 'gridInputCustomStyle'; 
					return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER'); 
				}	

			}else{
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER'); 
			}	
		}
	},{
		header:getCommonTranslation('ADDITIONAL_SETUP'),
		dataIndex:'additionalSetUp',
		sortable:false,
		flex:0.1,
		renderer : function(value, rec, record, rowIndex, colIndex, store, view){
			var data=record.data;
			if (data.moduleCode != 'STEP24_RECEIPTS' && data.moduleCode != 'STEP20_PAYMENTS' && data.moduleCode != 'STEP35_DOCUMENT_REQUEST' &&
					data.moduleCode != 'STEP36_DASHBOARD' && data.moduleCode != 'STEP37_SCHOLARSHIP') {
				if(!isNullOrEmpty(record.data.applicantPortalSetupId)){
					return  '<a href="#">'+"Setup"+'</a>';
				}else{
					return 'Setup';
				}
			}

		}
	}],
	plugins: {
		ptype: 'cellediting',
		clicksToEdit: 1
	},
	listeners: {
		beforeedit: function(editor, context) {
			if(editor.context.field=='sequenceNo'){
				if(context.record.data.moduleName == 'Program Details' || context.record.data.moduleCode == 'STEP10_DECLARATION_N_PAYMENTS' || context.record.data.moduleCode == 'STEP36_DASHBOARD'){
					context.grid.columns[3].getEditor().setReadOnly(true);
					return context.colIdx !== 3;
				}else{
					context.grid.columns[3].getEditor().setReadOnly(false);
				}

			}
			if(editor.context.field=='appPortalApplicationStatus'){
				var applicantStatusArr =[];
				var applicantStatusRecord = context.record.data.appPortalApplicationStatus;
				if(applicantStatusRecord.length >0) {
					for(var i=0;i<applicantStatusRecord.length;i++){
						if(!isNullOrEmpty(applicantStatusRecord[i].applicationStatus)){
							applicantStatusArr.push(applicantStatusRecord[i].applicationStatus);
						}
						else{
							applicantStatusArr.push(applicantStatusRecord[i]);
						}
					}
				}
				var colEditore =context.grid.columns[4].getEditor();
				context.grid.columns[4].getEditor().getStore().load({
					callback:function(values){
						colEditore.setValue(applicantStatusArr);
						colEditore.select(applicantStatusArr);
					}
				});
				if(context.record.data.moduleCode == 'STEP36_DASHBOARD'){
					context.grid.columns[4].getEditor().setReadOnly(true);
					return context.colIdx !== 4;
				}else{
					context.grid.columns[4].getEditor().setReadOnly(false);
				}
			}
		}
	}
}
);