/**
 * Akshay Sharma
 * 
 */
Ext.define('Academia.view.attendance.ConsolidateCourseWiseSearchAttendance', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.consolidatecoursewisesearchattendance',  
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype : 'fieldcontainer',
		width: 'auto',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [
			{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'academicTerm',
				itemId : 'academicTermId',
				displayField : 'value',
				store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				valueField : 'id',
				typeAhead : true,
				editable : false
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('INTAKE_YEAR'),		
				name : 'intakeYear',
				itemId : 'intakeYearId',
				displayField : 'value',
				store:Ext.create('Academia.store.common.BatchIntakeYearStore'),
				valueField : 'id',
				typeAhead : true,
				editable : false
			},{
				xtype : 'customcombobox',
				width:226,
				fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
				name : 'courseId',
				itemId : 'courseId',
				store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourses'),
				displayField : 'courseCodeName',
				valueField : 'courseId',
				typeAhead : true,
				disable:true,
				forceSelection : true,
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				enableKeyEvents  : 'true',
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{courseCodeName}'  +
						'</div>';
					}
				}

			}]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [
			{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
				name : 'courseVariant',
				itemId : 'courseVariantId',
				store: Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),
				displayField : 'courseVariantCode',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				disabled:true,
				editable : false

			},{
				xtype: 'customcombobox',
				name:'faculty',
				itemId:'facultyId',
				store: Ext.create('Academia.store.coursetransaction.facultytopicassignment.ParameterizedFaculties'),
				fieldLabel :getCommonTranslation('FACULTY_CODE'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				hidden:false,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}

			},{
				xtype: 'customcombobox',
				name: 'courseTopic',
				itemId: 'courseTopicId',
				fieldLabel : getCommonTranslation('TOPICS'),
				store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.TopicByCourseId',
				displayField:'value',
				valueField:'id',
				disabled:true,				
				allowBlank:true,
				forceSelection:true,
				queryParam:'topicName',
				minChars:3,
				//hidden:false,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				//enableKeyEvents  : 'true',
				//hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			 }]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [
			{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('START_DATE'),
				name : 'consolidateStartDate',
				itemId:'consolidateStartDate',
				endDateField : 'consolidateEndDate',
				format : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange',
				maxValue:new Date()
			},{
				xtype : 'datefield',
				fieldLabel :getProgramandcourseTranslation('END_DATE'),
				name : 'consolidateEndDate',
				itemId : 'consolidateEndDate',
				startDateField : 'consolidateStartDate',
				format : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange',
				maxValue:new Date()

			}
			]},
			{ 
				xtype : 'fieldcontainer',
				width: '100%',
				layout:'hbox',
				itemId:'timeContainer',
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				items : [{
					xtype : 'timefield',
					name : 'fromTime',		
					itemId : 'fromTime',			
					fieldLabel:getProgramandcourseTranslation('START_TIME'),
					format:'g:i A',
					increment: 1,
					width:107,
					listeners:{
						change:function(obj,val){
							if (!isNullOrEmpty(val)) {
								var sDate = Ext.Date.add(val, Ext.Date.MINUTE, 1);
								obj.nextSibling().setMinValue(sDate);	
							}
						}
					},

				},{
					xtype : 'timefield',
					name : 'toTime',		
					itemId : 'toTime',			
					fieldLabel:getProgramandcourseTranslation('END_TIME'),
					format:'g:i A',
					increment: 1,
					width:107,
					listeners:{
						change:function(obj,val){
							if (!isNullOrEmpty(val)) {
								var eDate = Ext.Date.add(val, Ext.Date.MINUTE, -1);
								obj.previousSibling().setMaxValue(eDate);
							}
						}
					},
				}]
			},{

				xtype: 'fieldset',
				collapsible : true,
				collapsed: true,
				title: getCommonTranslation('MORE_DETAILS'),
				titleCollapse: true,
				itemId : 'moreDetailId',
				defaults : {
					labelAlign:'top',
				},
				style: {
					marginTop: '33px!important'
				},
				items:[{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 226
					},
					items: [{
						xtype: 'customcombobox',
						name: 'programCategory',
						itemId:'programCategoryId',
						fieldLabel : getProgramandcourseTranslation('PROGRAM_CATEGORY'),
						store: Ext.create('Academia.store.program.ProgramCategoryByAlStore'),
						valueField: 'id',
						displayField: 'value',
						typeAhead:true,
						forceSelection:true,
						editable : false
					},{
						xtype : 'customcombobox',
						fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
						name : 'program',
						itemId : 'programId',
						store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
						displayField:'valueCode',
						valueField:'id',
						triggerAction: 'all',
						queryParam:'name',
						minChars:3,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						forceSelection:true,
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}'  +
								'</div>';
							}
						}

					},
					{
						xtype: 'customcombobox',
						name: 'batch',
						itemId:'batchId',
						fieldLabel : getCourseTxCommonTranslation('BATCH'),
						disabled:true,
						store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
						valueField: 'id',
						displayField: 'value',
						typeAhead:true,
						forceSelection:true,
						editable : false
					}]
				}, {
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 226
					},
					items: [{
						xtype: 'customcombobox',
						name: 'period',
						itemId:'periodId',
						fieldLabel: getExaminationTranslation('PERIOD'),
						store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
						displayField:'value',
						valueField:'id',
						forceSelection:true,
						typeAhead:true,
						disabled:true,
						editable : false
					}]
				}]

			},{
				xtype: 'fieldcontainer',
				width: '100%',

				items: [{
					xtype: 'button',
					text: getCommonTranslation('SEARCH'),
					itemId: 'searchBtn',
					buttonAlign: 'left',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE,
				},{
					xtype: 'button',
					text: getCommonTranslation('VIEW_QR'),
					itemId: 'GenrateQR',
					buttonAlign: 'left',
					ui: 'CustomBtnSubmit',
					formBind : false,
					disabled:true,
					scale: CONSTANTS.BUTTONSIZE
				},{
					xtype: 'button',
					text: getCourseTxCommonTranslation('RESET'),
					itemId: 'resetBtn',
					buttonAlign: 'left',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE	        				
				}]
			}
			]
});
