/**
 * Abhishek Bais
 * 
 */
Ext.define('Academia.view.attendance.CourseWiseDailyAttendanceSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.coursewisedailyattendancesearch',  
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype : 'fieldcontainer',
		width: 'auto',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'customcombobox',
			name : 'academicTerm',
			itemId : 'academicTerm',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			store :Ext.create('Academia.store.common.AcademicTermStore'),
			valueField : 'id',
			displayField : 'value',
			forceSelection:true,
			typeAhead:false,
			

		},
		{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
			name : 'courseVariant',
			itemId : 'courseVariantId',
			store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),
			displayField: 'courseVariantCode',
			valueField: 'id',
			triggerAction: 'all',
			queryParam:'name',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			typeAhead:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}


		},{
			xtype: 'customcombobox',
			name: 'courseTopic',
			itemId: 'courseTopicId',
			fieldLabel : getCommonTranslation('TOPICS'),
			store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.TopicByCourseId',
			displayField:'value',
			valueField:'id',
			disabled:true,				
			allowBlank:true,
			forceSelection:true,
			queryParam:'topicName',
			minChars:3,
			hidden:false,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		 }]
	},
	{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'datefield',
			fieldLabel : getProgramandcourseTranslation('START_DATE'),
			name : 'courseWiseStartDate',
			itemId:'courseWiseStartDate',
			endDateField : 'courseWiseEndDate',
			format : CONSTANTS.DATE_FORMAT,
			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			vtype : 'daterange',
			maxValue:new Date()
		},{
			xtype : 'datefield',
			fieldLabel :getProgramandcourseTranslation('END_DATE'),
			name : 'courseWiseEndDate',
			itemId : 'courseWiseEndDate',
			startDateField : 'courseWiseStartDate',
			format : CONSTANTS.DATE_FORMAT,
			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			vtype : 'daterange',
			maxValue:new Date()

		}
		]},
		{ 
			xtype : 'fieldcontainer',
			width: '100%',
			layout:'hbox',
			itemId:'timeContainer',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'timefield',
				name : 'fromTime',		
				itemId : 'fromTime',			
				fieldLabel:getProgramandcourseTranslation('START_TIME'),
				format:'g:i A',
				increment: 1,
				width:107,
				listeners:{
					change:function(obj,val){
						if (!isNullOrEmpty(val)) {
							var sDate = Ext.Date.add(val, Ext.Date.MINUTE, 1);
							obj.nextSibling().setMinValue(sDate);	
						}
					}
				},
				
			},{
				xtype : 'timefield',
				name : 'toTime',		
				itemId : 'toTime',			
				fieldLabel:getProgramandcourseTranslation('END_TIME'),
				format:'g:i A',
				increment: 1,
				width:107,
				listeners:{
					change:function(obj,val){
						if (!isNullOrEmpty(val)) {
							var eDate = Ext.Date.add(val, Ext.Date.MINUTE, -1);
							obj.previousSibling().setMaxValue(eDate);
						}
					}
				},
			}]
		},
		{
			xtype: 'fieldcontainer',
			width: '100%',

			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE	        				
			}]
		}
		]
});
