Ext.define('Academia.view.attendance.attendancesettings.AttendanceSettingsGrid',{
	extend : 'Ext.grid.Panel',
	alias : 'widget.attendancesettingsgrid',
	store : 'attendance.attendancesettings.AttendanceSettingsGrid',
	title : getProgramandcourseTranslation('ATTENDANCE_SETTINGS'),
	border: true,
	sortable : true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	 headerFix:{
         headerFix: true,
         portalIdsWithStructure: {
             'attendancesettingsmaster':1
         }
     },
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			store : 'attendance.attendancesettings.AttendanceSettingsGrid',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns : [/*{
		header :getProgramandcourseTranslation("ID"),
		hidden:false,
		dataIndex:'id'
	},*/{
		header :getProgramandcourseTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocation',
		flex:1
	},{
		header : getProgramandcourseTranslation('STUDENT_ATTENDACE_TYPE'),
		dataIndex : 'studentAttendanceType',
		flex:1,
		renderer:function(value){
			return getCommonTranslation(value);
		}
	},/*{
		header :getProgramandcourseTranslation('FACULTY_ATTENDANCE_TYPE'),
		dataIndex : 'facultyAttendanceType',
		flex:1,
		renderer:function(value){
			return getCommonTranslation(value);
		}
	},*/{
		header :getProgramandcourseTranslation('ATTENDANCE_SORTING_TYPE'),
		dataIndex : 'sortBy',
		flex:1,
		renderer:function(value){
			return getProgramandcourseTranslation(value);
		 }
	},{
		header :getProgramandcourseTranslation('BACK_DATE_ALLOWED_CORE_ERP'),
		dataIndex : 'backDateAllowed',
		flex:1
	},{
		header :getProgramandcourseTranslation('BACK_DATE_ALLOWED_FOR_FACULTY'),
		dataIndex : 'backDateAllowedForFaculty',
		flex:1
	},{
		header : getProgramandcourseTranslation('ATTENDANCE_SLOTS'),
		dataIndex : 'attendanceSlot',
		flex:1,
        renderer: function(value) {
            if (value=="NONE") {
            	return "-";
            } else {
            	return "<span style=\'color:green\'>"+getCommonTranslation(value)+"</span>";
            }
        }
	},{
		header : getCommonTranslation('AD_HOC_SLOTS'),
		dataIndex : 'whetherAdhocRequired',
		flex:1,
		renderer: function(value,obj) {
        	var studentAttendanceTypeObj = obj.record.data.studentAttendanceType;
        	var attendanceSlot = obj.record.data.attendanceSlot;
        	if(studentAttendanceTypeObj =='Course Level' || studentAttendanceTypeObj =='COURSE_LEVEL' ||studentAttendanceTypeObj=='SERVICE_LEVEL' || studentAttendanceTypeObj=='Service Level' ){
        		if (value) {
        			return "<span style=\'color:green\'>Yes</span>";
                } else {
                	return "<span style=\'color:red\'>No</span>";
                }	
        	}else{
        		return "-";
        	}
		}
	},{
		header : 'qrCodeExpiryTime',
		dataIndex : 'qrCodeExpiryTime',
		flex:1,
		hidden: true
	}]

});
