/**
 * Akshay Sharma
 * 
 */
Ext.define('Academia.view.attendance.courseattendance.CourseSearchAttendancePBS', {   
	extend : 'Academia.view.common.DynamicFieldForm',
	alias : 'widget.coursesearchattendancepbs',  
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype : 'hidden',
		name:'selectedStudentId',
		itemId:'selectedStudentId'
	},{
		xtype : 'hidden',
		name:'selectedPeriodId',
		itemId:'selectedPeriodId'
	},{
	    xtype: 'fieldcontainer',
	    layout: {
	        type: 'hbox'
	    },
	    defaults: {
	        width: '226',
	        labelAlign: 'top'
	    },
	    items: [{
			xtype : 'customcombobox',
			name : 'academyLocation',
			itemId:'academyLocationId',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'attendance.attendancereport.AcadmyByAdmission',
			width:226,
			valueField : 'id',
			displayField : 'value',
		//	allowBlank : false,
			minChars:3,
			typeAhead : false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			queryParam:'qry',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
	        xtype: 'customcombobox',
	        name: 'academicTerm',
	        itemId: 'academicTermId',
	        width:226,
	        fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
	        store: Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
	        valueField: 'id',
	        displayField: 'value',
	        forceSelection:true,
	        allowBlank : false,
	        typeAhead : false,
			editable : false
	    }]
	},{
		xtype : 'fieldcontainer',
		itemId:'programBatch_Id',
		width: 'auto',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'hidden',
			name : 'id'
		},{
        	xtype: 'customcombobox',
            name: 'programCategory',
            itemId : 'programCategoryId',
            fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
//            translationKey: 'PROGRAM_CATEGORY',
            store: Ext.create('Academia.store.program.ProgramCategoryByAlStore'),
            displayField:'value',
            valueField:'id',
            forceSelection:true,
            //allowBlank: false
        },{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			name : 'programId',
			itemId : 'programBatch_programId',
			store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
			displayField:'valueCode',
			valueField:'id',
			width:226,
			typeAhead:false,
			allowBlank : false,
			forceSelection:true,
			queryParam:'name',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'programBatch_batchId',
			fieldLabel : getCourseTxCommonTranslation('BATCH'),
			disabled:true,
			store: Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:false,
			forceSelection:true,
			allowBlank : false,
			width: 226,
			editable : false
		}]
	},{
		 xtype : 'fieldcontainer',
		 width: 'auto',
		 defaults : {
			 width : 226,
			 labelAlign : 'top'
		 },
		 layout : {
			 type : 'hbox'
		 },
		 items : [{
			 xtype: 'customcombobox',
			 name: 'periodId',
			 itemId:'programBatch_periodId',
			 fieldLabel: getExaminationTranslation('PERIOD'),
			 store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
			 displayField:'value',
			 valueField:'id',
			 forceSelection:true,
		//	 allowBlank : false,
			 typeAhead:false,
			 disabled:true,
			 width: 226,
			 editable : false
		 },{
			 xtype : 'customcombobox',
			 fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
			 name : 'courseId',
			 itemId : 'courseId',
			 //store:'attendance.StudentCourses',
			 store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourses'),
			 displayField : 'courseCodeName',
			 valueField : 'courseId',
			 forceSelection : true,
			 queryParam:'name',
			 minChars:3,
			 hideTrigger:false,
			 typeAhead:true,
			 triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			 listConfig: {
				 listeners: {
					 beforeshow: function(picker) {
						 picker.minWidth = picker.up('combobox').getSize().width;
					 }
				 },
				 loadingText: getCommonTranslation('SEARCHING'),
				 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				 getInnerTpl: function() {
					 return '<div class="search-item">' +
					 '{courseCodeName}'  +
					 '</div>';
				 }
			 }
		 },{
			 xtype : 'customcombobox',
			 fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
			 name : 'courseVariant',
			 itemId : 'courseVariantId',
			 store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),
			 displayField : 'courseVariantCode',
			 valueField : 'id',
			 typeAhead : true,
			 forceSelection : true,
			 disabled:true,
			 editable : false
		 }]
	},{

		xtype: 'fieldset',
		collapsible : true,
		collapsed: true,
		title: getCommonTranslation('MORE_DETAILS'),
		titleCollapse: true,
		itemId : 'moreDetailId',
		defaults : {
			labelAlign:'top',
		},
		style: {
			marginTop: '33px!important'
		},
		items:[{

			xtype : 'fieldcontainer',
			width: 'auto',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
	     		xtype: 'customcombobox',
	     		name:'studentId',
	     		itemId:'studentId',
	     		store: Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.FacultyParamCourseStudentStore'),
	     		fieldLabel : getExaminationTranslation('STUDENTID_STUDENTNAME'),
	     		valueField: 'id',
	 			displayField: 'valueCode',
	 			queryParam:'name',
	     		minChars:3,
	     		typeAhead:false,
	     		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	     		enableKeyEvents  : 'true',
	     		hideTrigger:false,
	     		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	     		triggerAction: '',
	     		forceSelection:true,
	     		listConfig: {
	     			listeners: {
	 					beforeshow: function(picker) {
	 						picker.minWidth = picker.up('combobox').getSize().width;
	 					}
	 				},
	     			loadingText: getCommonTranslation('SEARCHING'),
	     			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	     			getInnerTpl: function() {
	     				return '<div class="search-item">' +
	     				'{value} / {code}' +
							'</div>';
	     			}
	     		}
	     	},{
				xtype: 'statusCombo',
				name: 'STATUS',
				itemId:'statusComboItemId',
				width:226,
				value:true,
				editable:false
			},{
				xtype : 'numberfield',
				name : 'absentAboveNumberOfSessions',
				itemId : 'absentAboveNumberOfSessions',
				maxValue:365,
				fieldLabel : getCourseTxCommonTranslation('ABSENTS_ABOVE_NO_OF_DAYS_SESSIONS'),
				value : 0,
				minValue : 0,
				maxValue:365,
				mouseWheelEnabled :false,
				hideTrigger :true,
				allowExponential:false,
				allowDecimals:false
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype : 'numberfield',
				name : 'minAbsentPercentage',
				itemId : 'minAbsentPercentagePBSId',
				fieldLabel : getCourseTxCommonTranslation('MIN_ABSENT_PERCENTAGE'),
				value : 0,
				minValue : 0,
				maxValue:100,
				mouseWheelEnabled :false,
				hideTrigger :true,
				allowExponential:false,
				allowDecimals:false,
				validator : function(val) {
					var attendancePercentageFromField = Ext.ComponentQuery.query('numberfield#attendancePercentageFromPBSId')[0];
					var attendancePercentageToField = Ext.ComponentQuery.query('numberfield#attendancePercentageToPBSId')[0];
					if (val > 0) {
						attendancePercentageFromField.setDisabled(true);
						attendancePercentageToField.setDisabled(true);
					} else if(val==0) {
						attendancePercentageFromField.setDisabled(false);
						attendancePercentageToField.setDisabled(false);
					}
					return true;
				}
			},{
				xtype : 'numberfield',
				name : 'attendancePercentageFrom',
				itemId : 'attendancePercentageFromPBSId',
				fieldLabel : getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_FROM'),
				minValue : 0,
				maxValue:100,
				mouseWheelEnabled :false,
				hideTrigger :true,
				allowExponential:false,
				allowDecimals:false,
				validator : function(minValue) {
					var minAbsentPercentageField = Ext.ComponentQuery.query('numberfield#minAbsentPercentagePBSId')[0];
					var attendancePercentageToField = Ext.ComponentQuery.query('numberfield#attendancePercentageToPBSId')[0];
					var maxValue = attendancePercentageToField.getValue();
					if (minValue > 0 && (maxValue > 0|| maxValue=="" || maxValue== null)) {
						minAbsentPercentageField.setDisabled(true);
						
					}else if(minValue=="" && (maxValue==""|| maxValue==null)) {
						minAbsentPercentageField.setDisabled(false);
					}
					if(maxValue!="" && maxValue!= null ){
						if(minValue <= maxValue){
							attendancePercentageToField.clearInvalid();
		 	   				 return true;
						}else{
							return getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_FROM')+' should be less then '+getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_TO');
						}
							
					}else{
						return true;
					}
					
				}
			},{
				xtype : 'numberfield',
				name : 'attendancePercentageTo',
				itemId : 'attendancePercentageToPBSId',
				fieldLabel : getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_TO'),
				minValue : 0,
				maxValue:100,
				mouseWheelEnabled :false,
				hideTrigger :true,
				allowExponential:false,
				allowDecimals:false,
				validator : function(maxVal) {
					var minPresentPercentageField = Ext.ComponentQuery.query('numberfield#minAbsentPercentagePBSId')[0];
					var attendancePercentageFromField = Ext.ComponentQuery.query('numberfield#attendancePercentageFromPBSId')[0];
					var minValue = attendancePercentageFromField.getValue();
					if (maxVal > 0 && (minValue > 0 || minValue=="" || minValue== null)) {
						minPresentPercentageField.setDisabled(true);
					} else if(maxVal=="" && (minValue==""|| minValue==null)) {
						minPresentPercentageField.setDisabled(false);
					}
					if(minValue!="" && minValue!= null &&
							maxVal!="" && maxVal!=null){
						if( maxVal>= minValue){
							attendancePercentageFromField.clearInvalid();
		 	   				 return true;
						}else{
							return getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_TO')+' should be greater then '+getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_FROM');
						}
							
					}else{
						return true;
					}
					
					
				}
			}]
    	 
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			itemId:'fldDateFields',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('START_DATE'),
				name : 'startDate',
				itemId : 'startDate',
				endDateField : 'tillDate',
				vtype : 'daterange',
				//maxValue:new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					},
					change: function(me, newValue, oldValue, eOpts) {
						if(!isNullOrEmpty(newValue))
						{
							var date = me.parseDate(newValue);
    						var startDate = me.up().down("#startDate");
    						var end = me.up().down("#tillDate");
    						var newDate = date.setMonth(date.getMonth()+6);
	                    	newDate = new Date(newDate);
	                    	end.setMaxValue(newDate);
	                    	startDate.isValid();
						}
					}
				}
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getProgramandcourseTranslation('END_DATE'),
				name : 'tillDate',
				itemId : 'tillDate',
				startDateField : 'startDate',
				vtype : 'daterange',
				//maxValue:new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					},
					change: function(me, newValue, oldValue, eOpts) {
						if(!isNullOrEmpty(newValue))
						{
    						var date = me.parseDate(newValue);
    						var startDate = me.up().down("#startDate");
    						var endDate = me.up().down("#tillDate");
	                    	var newDate = date.setMonth(date.getMonth()-6);
	                    	newDate = new Date(newDate);
	                    	startDate.setMinValue(newDate);
	                    	endDate.isValid();
						}
					}
				}
			}]
		}]
	
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE	        				
		}]
	}
	]
});