/**
 * @author Niklesh Tiwane
 * 
 * show list of notification/alert in notification window.
 *    
 */
Ext.define('Academia.view.baselayout.header.NotificationAlertForRecentVisitedUsers', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.notificationalertforrecentvisitedusers',  
    items:[{
    	xtype: 'dataview',
    	autoScroll: false,
    	//store: 'userProfileLastActivity.notificationAlertForRecentVisitedUsers.NotificationAlertForRecentVisitedUsersStore',
    	tpl: new Ext.XTemplate(
    			'<div class="notify-recent-visited-container">', 
    		    '<tpl if="values.length === 0">',
    		    '<div class="title" id="recentVisitedUsersId">{[getCommonTranslation("RECENT_VISITED_USERS")]}</div>',  
    		        '<div class="no-data-message">{[getCommonTranslation("NODATADISPLAYMSG")]}</div>',
    		    '<tpl else>',
    		        '<div class="title" id="recentVisitedUsersId">{[getCommonTranslation("RECENT_VISITED_USERS")]}</div>',  
    		        '<div class="users-wrapper">',  
    		            '<tpl for=".">',  
    		                '<div class="user-box">',  
    		                    '<div class="profile-img-wrapper">',  
    		                        '<tpl if="image && image !== \'\'">',
    		                            '<img src="{[this.getFullImagePath(values.imageURL)]}" alt="{firstName} {lastName}" class="profile-img" ' +
    		                            'onerror="this.onerror=null; this.src=\'{[this.getFallbackImage(values.firstName, values.middleName, values.lastName)]}\';" ' +
    		                            'height="40" width="40">',
    		                        '<tpl else>',
    		                        '<img src="{[this.getFallbackImage(values.firstName, values.middleName, values.lastName)]}" alt="{firstName} {lastName}" class="profile-img">',
    		                        '</tpl>',
    		                    '</div>',
    		                    '<div class="user-name">{firstName} {lastName}</div>',  
    		                '</div>',  
    		            '</tpl>',
    		            '<div>',
    		                '<img src="resources/images/arrow_blue.svg" id="redirectToProfilePageId">',
    		            '</div>',
    		        '</div>',
    		    '</tpl>',
    		'</div>',
    		{
    		    getFullImagePath: function (imageURL) {
    		        var extensionArr = imageURL.split(".");
    		        var imageUrl = "resources/images/uploads" + extensionArr[extensionArr.length - 2] + "_icon." + extensionArr[extensionArr.length - 1];
    		        return imageUrl;
    		    },
    		    
    		    getFallbackImage: function (firstName, middleName, lastName) {
    		        return generateInitialsImage(firstName, middleName, lastName);
    		    }
    		}	    			
    	),
    }]


});