Ext.define('Academia.view.baselayout.header.NotificationSearchForm' ,{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.notificationSearchForm',
	frame: false,
	cls:'customSearchPanel',
	plugins: "formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top'
		},
		items:[{
			xtype : 'radiogroup',
			itemId:'dateRangeDetails',
			labelAlign : 'top',
			defaults: {
				flex: 1
			},
			items : [{
				boxLabel : getCommonTranslation('TODAY'),
				name : 'dateRange',
				inputValue : 'TODAY'
			},{
				boxLabel : getCommonTranslation('LAST_WEEK'),
				name : 'dateRange',
				inputValue : 'LAST_WEEK'

			},{
				boxLabel : getCommonTranslation('LAST_MONTH'),
				name : 'dateRange',
				inputValue : 'LAST_MONTH'
			}]
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'datefield',
            name: 'startDate',
            fieldLabel: getAdmissionTranslation('START_DATE'),
            vtype: 'daterange',
            itemId: 'startDate',
            endDateField: 'endDate',
            maxValue:new Date(),
             listeners: {
            	/*select: function(field, value) {
                    var dateRangePicker = this.up('notificationactivitygridextendeddatefilter');
                    var endDate = dateRangePicker.endDate;
                    dateRangePicker.setDates(value, endDate);
                    var contentPanelMain = this.up('activityfeeds');
						 if(contentPanelMain){
								 contentPanelMain.scrollBy(0,1);
								 contentPanelMain.scrollBy(0,-1);
						 }
                },*/
                render: function(field) {
                	return dateFormatRender(field);
                }
            }
		},{
			 xtype: 'datefield',
             name: 'endDate',
             fieldLabel: getAdmissionTranslation('END_DATE'),
             itemId: 'endDate',
             vtype: 'daterange',
             startDateField: 'startDate',
             maxValue:new Date(),
             listeners: {
             	/*select: function(field, value) {
                     var dateRangePicker = this.up('notificationactivitygridextendeddatefilter');
                     var startDate = dateRangePicker.startDate;
                     dateRangePicker.setDates(startDate,value);
                     var contentPanelMain = this.up('activityfeeds');
						 if(contentPanelMain){
								 contentPanelMain.scrollBy(0,1);
								 contentPanelMain.scrollBy(0,-1);
						 }
                 },*/
                 render: function(field) {
                 	return dateFormatRender(field);
                 }
             }
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('APPLY'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind: true,
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	
	}]
});
