Ext.define('Academia.view.baselayout.megamenu.VerticalNavigationMenu',{
	extend:'Ext.panel.Panel',
	alias:'widget.verticalNavigationMenu',

	id: 'menuHolder',
	cls: 'mymenu',
	header:{
		layout:
	    {
	        type: 'hbox',
	        pack: 'end'
	    },
		items:[{
            xtype: "combo",
            itemId: "searchComboBox",
            cls: "searchComboBoxCls",
            store: "MainSearchStore",
            displayField: "searchText",
            valueField: "menuId",
            hideLabel: true,
            width: 150,
            hideTrigger: true,
            enableKeyEvents: true,
            allowCollapse: false,
            minChars: 0,
            queryMode: "local",
            emptyCls: "search-empty-text-field MenuSearchCLS",
            emptyText: getCommonTranslation("MENU_SEARCH"),
            listConfig: {
                loadingText: getCommonTranslation("SEARCHING"),
                emptyText: getCommonTranslation("NO_MATCH"),
                cls: "searchMenuListCls",
                getInnerTpl: function() {
                    return '<a class="searchItemCls"><span role="img" class="x-btn-icon-el {iconCls}">&nbsp;</span><span class="displayPathCls">{displayPath}</span><span class="titleCls">{title}</span></a>'
                }
            },
            listeners: {
                select: function(d) {
                    d.allowCollapse = true;
                    try {
                        var c = Ext.getCmp(d.getValue());
                        c.fireEvent("click", c)
                    } catch (b) {
                        $("#" + d.getValue())[0].click()
                    }
                    d.setValue("");
                    setTimeout(function() {
                        d.allowCollapse = false
                    }, 300)
                },
                beforequery: function(b) {
                    var c = "ig";
                    if (b.query === b.query.toUpperCase() && b.query.length > 1) {
                        c = "g"
                    }
                    b.query = new RegExp(b.query,c);
                    b.forceAll = true;
                    this.getStore().sort([{
                        property: "title",
                        direction: "ASC"
                    }])
                }
            }
        }]
	},
	hideHeaders : false,
	collapsible : true,
	animate : true,
	animCollapse: true,
	titleCollapse : true,
	//hidden:true,
	overflowX: false,
	margin:'0',
	style:{'z-index':'99'}, //V2D-345970
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	 items:[ ], 
	initComponent : function() {
	
		this.loadComponent();
		this.callParent();
	},
	placeholder : {
		collapseDirection: 'left',
		titleCollapse: 'true',
		id: 'placeholderLbar',
		//required for limiting the length of the collapsed menu to 50px.
		width: 60,
		listeners:{
			afterrender: function(){
				setTimeout(function(){
					applyMenuBottomBorder();
				},1000);
			}
		}
	},
	loadComponent:function(){
		var this$=this;
		var toggleCollapseTool = {
				xtype: 'verticalMenuCollapseIcon',
				itemId:'menuTogglerItem',
				iconCls: 'menuToggler',
				height: 65
			};
		
		var MegaMenuModel=Academia.model.menu.MegaMenuDataModel;
		var menuData=MegaMenuModel.menuData;
		
		this$.getPlaceholder().add(toggleCollapseTool);
		menuData.sort(function(a, b){
			return a.displayOrder-b.displayOrder;
		});
		var itemsArray=new Array();
		Ext.each(menuData,function(record){
			var menuItem=Ext.create('Academia.view.baselayout.megamenu.VerticalNavigationMenuButton');
			menuItem.initialize(record);
//			menuItem.addCls('menu-button');
			itemsArray.push(menuItem);
			var menuComponent=Ext.create('Academia.view.baselayout.megamenu.VerticalMenuCollapseIcon');
			menuComponent.initialize(record);
			this$.getPlaceholder().add(menuComponent);
		});
		this$.items=itemsArray;
		
		setTimeout(function(){
			applyMenuBottomBorder();
		},500);
	}

});
