Ext.define('Academia.view.calendar.HolidayDetailsCalendarGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.holidaydetailscalendargrid',
    store: 'calendar.HolidayListGridStore',
    title: getCommonTranslation('CALENDAR_HOLIDAY_LIST'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
        var Btn = grid.query('toolbar')[0];
        var expPdfBtn =  Btn.down('#exportPDFAll');
        var expExcelBtn =  Btn.down('#exportExcelAll');
        expPdfBtn.setVisible(false);
        expExcelBtn.setVisible(false);
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAddHoliday',
        dataIndex:'add',
        text: getCommonTranslation('ADD_HOLIDAY'),
        tooltip: getCommonTranslation('ADD_HOLIDAY'),
    }],
    columns: [{
    	header: getCommonTranslation('DATE'),
        dataIndex: 'fromDate',
        flex: 1,
        sortable: true,
        editor: {
            xtype: 'datefield',
            name: 'fromDate',
            itemId: 'fromDateItemId',
          //--submitFormat: CONSTANTS.DATE_FORMAT,
          
            vtype: 'daterange',
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            var grid = view.up();
            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.assignPrefillFromDate)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var store = grid.getStore();
                var models = grid.getStore().getRange();
                if (!isNullOrEmpty(val)) {

                } else if (!isNullOrEmpty(record.data.assignPrefillFromDate)) {
                    val = record.data.assignPrefillFromDate;
                }
                models[rowIndex].set("fromDate", val);
                models[rowIndex].set("assignPrefillFromDate", val);
                return dateRender(val);
            }
        }
    }, {
    	header: getCommonTranslation('CALENDAR_OCCASION'),
        dataIndex: 'holidayReason',
        flex: 1,
        sortable: true,
        editor: {
            xtype: 'textfield',
            name: 'holidayReason',
            itemId: 'holidayReasonItemId',
            maxLength: 100,
        },
        renderer: function(val, rec) {
            if (isNullOrEmpty(val)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
    }, {
        header: getServiceRequestTranslation('EMM_ADD'),
        dataIndex: 'addButton',
        flex: 0.5,
        cls: 'CustomBodyBtnSettings',
        tooltip : getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        sortable: true,
        renderer: function(value, meta, record) {
        	if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow || !isNullOrEmpty(record.data.id)){
        		if(record.store.data.length-1 == meta.recordIndex){
        	return "<div class='addButtonClsForGridActionCls' data-qtip='Add' style='marginRight: 20 auto !important'></div>";
        		}

        	}else{
        		return '';
        	}
        }
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        flex: 0.6,
        cls: 'CustomBodyBtnSettings',
        tooltip : getCommonTranslation('DELETE'),
        sortable: true,
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            if (rowIndex > 0 && !isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow || !isNullOrEmpty(record.data.id)) {
                return "<div class='deleteButtonClsForGridActionCls' data-qtip='Delete' style='marginRight: 20 auto !important'></div>";
            }else if(rowIndex >= 0 && !isNullOrEmpty(record.data.isAddDeleteRow || !isNullOrEmpty(record.data.id))){
            	 return "<div class='deleteButtonClsForGridActionCls' data-qtip='Delete'  style='marginRight: 20 auto !important'></div>";
            }
            return '';
        }
    }],
    plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
            beforeedit: function(obj, editor, context) {
                if (editor.record.data.isEditable == 'ADD') {
                    return true;
                } else if (editor.record.data.isEditable == 'EDIT') {
                    return true;
                } else if (editor.record.data.isEditable == 'VIEW') {
                    return false;
                }
            }
        }
    }]
});

var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
    clicksToEdit: 1,
    listeners: {
        beforeedit: function(editor, context, e) {}
    }
});