/**
 * @author Abhishek Chouhan
 * This component is used for to Work Timing configuration Details Window for Employee Type Calendar
 */
Ext.define('Academia.view.calendar.worktimingconfiguration.WorkTimingDetailsWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.worktimingdetailswindow',
    modal: true,
    title: getCommonTranslation('CALENDAR_WORK_TIMING_CONFIGURATION_DETAILS'), //'Work Timing Configuration Details'
    items: [{
        xtype: 'form',
        itemId: 'employeeWorkTimingForms',
        method: 'POST',
        margin: 0,
        bodyPadding: '10 10 10 10',
        standardSubmit: false,
        plugins: "formlabelrequired",
        items: [{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'hidden',
                name: 'id'
            }, {
                xtype: 'hidden',
                name: 'dbId'
            }, {
                xtype: 'hidden',
                name: 'version'
            }, {
                xtype: 'customcombobox',
                name: 'weekday',
                itemId: 'weekday',
                allowBlank: false,
                fieldLabel: getCommonTranslation('CALENDAR_DAY'),
                store: 'common.WeekDaysComboStore',
                valueField: 'name',
                displayField: 'value',
                anyMatch: true,
                queryMode: 'local',
                enableKeyEvents: 'true',
                minChars: 3,
                forceSelection: true,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                triggerAction: 'all',
                hideTrigger: false,
                listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                            '{code} / {value}' +
                            '</div>';
                    }
                }
            }, {
                xtype: 'fieldcontainer',
                width: 236,
                itemId: 'isNightShift',
                items: [{
                    xtype: 'radiogroup',
                    style: {
                        marginLeft: '-2px !important'
                    },
                    itemId: 'formNightShiftId',
                    labelAlign: 'top',
                    fieldLabel: getCommonTranslation('NIGHT_SHIFT'),
                    columns: 2,
                    vertical: true,
                    items: [{
                            boxLabel: getAdmissionTranslation('YES'),
                            name: 'isNightShift',
                            inputValue: true,
                        },
                        {
                            boxLabel: getAdmissionTranslation('NO'),
                            name: 'isNightShift',
                            inputValue: false,
                            checked: true
                        }
                    ]
                }, ]
            }, ]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'timefield',
                name: 'startTime',
                itemId: 'startTime',
                fieldLabel: getCommonTranslation('CALENDAR_START_TIME'),
                format: CONSTANTS.DISPLAY_TIME_FORMAT,
                vtype: 'timerange',
                submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
                allowBlank: false
            }, {
                xtype: 'timefield',
                name: 'endTime',
                itemId: 'endTime',
                fieldLabel: getCommonTranslation('CALENDAR_END_TIME'),
                format: CONSTANTS.DISPLAY_TIME_FORMAT,
                vtype: 'timerange',
                submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
                allowBlank: false,

            }, {
                xtype: 'timefield',
                name: 'totalHours',
                itemId: 'totalHours',
                fieldLabel: getCommonTranslation('TOTAL_HOURS'),
                format: CONSTANTS.TIME_FORMAT_24hrs,
                vtype: 'timerange',
                //endTimeField : 'lateComingAllowedTill',
                readOnly: true,
                allowBlank: false,
                submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [,{
                xtype: 'timefield',
                name: 'lateComingAllowedTill',
                itemId: 'lateComingAllowedTill',
                fieldLabel: getCommonTranslation('LATE_COMING_ALLOWED_TILL'),
                format: CONSTANTS.DISPLAY_TIME_FORMAT,
                vtype: 'timerange',
                allowBlank: false,
                submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
            	},{
                    xtype: 'timefield',
                    name: 'earlyGoingAllowedAfter',
                    itemId: 'earlyGoingAllowedAfter',
                    fieldLabel: getCommonTranslation('EARLY_GOING_ALLOWED_AFTER'),
                    format: CONSTANTS.DISPLAY_TIME_FORMAT,
                    vtype: 'timerange',
                    allowBlank: false,
                    submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
                }/*,
                {
                    xtype: 'timefield',
                    name: 'minHoursOfFullDay',
                    itemId: 'minHoursOfFullDayItemId',
                    fieldLabel: getCommonTranslation('MIN_HOURS_FOR_FULL_DAY'),
                    format: CONSTANTS.TIME_FORMAT_24hrs,
                    vtype: 'timerange',
                    allowBlank: false
                }*/
            ]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'timefield',
                name: 'minHoursOfHalfDay',
                itemId: 'minHoursOfHalfDayItemId',
                fieldLabel: getCommonTranslation('MIN_HOURS_FOR_HALF_DAY'),
                format: CONSTANTS.TIME_FORMAT_24hrs,
                vtype: 'timerange',
                allowBlank: false,
                submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
                editable:false
            },
            {
                xtype: 'timefield',
                name: 'minHoursOfFullDay',
                itemId: 'minHoursOfFullDayItemId',
                fieldLabel: getCommonTranslation('MIN_HOURS_FOR_FULL_DAY'),
                format: CONSTANTS.TIME_FORMAT_24hrs,
                vtype: 'timerange',
                allowBlank: false,
                submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
                editable:false
            }, {
                xtype: 'numberfield',
                name: 'slot',
                itemId: 'slot',
                fieldLabel: getCommonTranslation('CALENDAR_TOTAL_TIME_SLOT'),
                minValue: 1,
                maxValue: 1440,
                allowBlank: false
            } ]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            style: {
                marginTop: '5px',
                marginLeft: '-3px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'btnSaveEmployeeWorkTiming',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'btnCancel',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});