/**
 * @author Gajendra verma
 */
Ext.define('Academia.view.campaign.dashboard.AppointmentDashboardReportFilter', {
	extend: 'Ext.form.FormPanel',
	alias : 'widget.appointmentdashboardreportfilter',
	autoScroll: true,
	frame: false,
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	cls: 'customSearchPanel',
	plugins:"formlabelrequired",
	defaults: {
		labelAlign: 'top',
		// width: 226
	},
	items:[{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		style :{
			  marginLeft: '6px'
		},
		items:[{
			xtype: 'multiselectcombofield',
			width: 690,
			height:58,
			name: 'academyLocation',
			itemId:'academyLocationId',
			cls:'commonAutoHeightMultiselectField',
			itemId: 'academyLocationId',
			allowBlank : false,
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'common.AcademyLocationNameSeparated',
			displayField:'value',
			valueField:'id',
			autoloadStore: false,
			matchFieldWidth:true,
			maxLength:15000,
			queryMode:'local',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]  
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		style: {
			marginLeft:'-0px !important'
		},
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		style :{
			  marginLeft: '6px'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'enquiryId',
			itemId:'enquiryId',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			minChars : 3,
			fieldLabel:getEnquiryTranslation('ENQUIRY_ID_OR_STUDENT_NAME'),
			store: 'enquiry.EnquiryCodeSearchStore',
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			 listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{code} / {value}'  +
		                    '</div>';
		                }
		            }
		},{
			xtype : 'customcombobox',
			fieldLabel : getEnquiryTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			width:226,
			editable: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store)
				}}
		},{
			xtype : 'customcombobox',
			fieldLabel: getEnquiryTranslation('ENQUIRY_OWNER'),
			name : 'enquiryOwner',
			itemId : 'enquiryOwner',
			store: 'dashboard.AppointmentDashboardPersonToMeetStore',
			valueField : 'id',
			displayField : 'value',
			queryParam : 'name',
			minChars : 3,
			hideTrigger : false,
			forceSelection : true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			triggerAction: '',
			maxLength:40,
			emptyText : getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig : {
				listeners : {
					beforeshow : function(
							picker) {
						picker.minWidth = picker
						.up('combobox')
						.getSize().width;
					}
				},
				loadingText : getCommonTranslation('SEARCHING'),
				emptyText : getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl : function() {
					return '<div class="search-item">'
					+ '{value}'
					+ '</div>';
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		style :{
			  marginLeft: '6px'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'programId',
			itemId:'programId',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			displayField:'valueCode',
			width:460,
			valueField:'id',
			forceSelection:true,
			store: 'program.ProgramByGroupIdStore',
			//forceSelection:true,
			minChars:3,
			queryParam:'qry',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'batch',
			itemId:'batchId',
			fieldLabel: getEnquiryTranslation('BATCH'),
			store: 'enquiry.AcademicBatchStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true,
			disabled:true,
			editable: false,
		},{
			xtype : 'multiselectcombofield',
			cls:'commonAutoHeightMultiselectField',
			fieldLabel: getCommonTranslation('SEAT_TYPE'),
			name: 'seatType',
			itemId:'seatType',
			displayField: 'value',
			valueField: 'id',
			typeAhead : true,
			forceSelection : true,
			editable: false,
			disableKeyFilter: false,
			disabled:true,
			store:'enquiry.SeatTypeStore',
			listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
			return '<div class="search-item">' +
						'{code}'  + '{value}' +
				        '</div>';
			}
			}
		}]  
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		style :{
			  marginLeft: '6px'
		},
		items:[{
			xtype: 'datefield',
			name: 'fromdate',
			itemId:'fromdate',
			allowBlank : false,
			
			vtype: 'daterange',
			endDateField: 'todate',
			fieldLabel: getFeeAndPaymentCommonTranslation('FROM_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype: 'datefield',
			name: 'todate',
			itemId:'todate',
			allowBlank : false,
			vtype: 'daterange',
			startDateField: 'fromdate',
			fieldLabel: getFeeAndPaymentCommonTranslation('TILL_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		style : {
			marginTop : '10px',
			marginLeft : '-2px'
		},
		style :{
			  marginLeft: '6px'
		},
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});