/**
 * @author Deepak S
 */
var CampaignNewGridStore = Ext.create('Academia.store.campaignnew.CampaignNewGridStore');
Ext.define('Academia.view.campaignnew.CampaignNewGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.campaignnewgrid',
	store: CampaignNewGridStore,
	title: getHostelTranslation('SEARCH_RESULT'),
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'campaignnewstructure':1
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	/*selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},*/
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store: CampaignNewGridStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnCaptureLead',
		tooltip: getCommonTranslation('CAPTURE_LEAD'),
		text: getCommonTranslation('CAPTURE_LEAD'),

	}],
	columns: [{
		header:  getCommonTranslation('INTAKE_YEAR'),
		dataIndex: 'intakeYearValue',
		flex:1,
		sortable:true,
		/*renderer:function(value,meta,record){
			return value.value;
		}*/
	},{
		header:  getCommonTranslation('MODE_OF_DELIVERY'),
		dataIndex: 'modeofDelivery',
		flex:1,
		hidden:true,
		sortable:true
	},{
		header:  getCommonTranslation('REGISTRATION_TYPE'),
		dataIndex: 'registrationType',
		flex:1,
		hidden:true,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				return getCommonTranslation(value);
			}
		}
	},{
		header:  getCommonTranslation('BRAND_CAMPUS'),
		dataIndex: 'noOfAcademyLocCount',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(value == 1){
				var alRec = record.get('academyLocations');
				return alRec[0].academyDisplayName;
			}
			else{
				if(!isNullOrEmpty(value)){
					return '<a href=#>'+value+'</a>';
				}
			}
		}
	},{
		header:  getCommonTranslation('CAMPAIGN_TYPE'),
		dataIndex: 'campaignType',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				return getCommonTranslation(value);
			}
		}
	},{
		header:  getCommonTranslation('PRESENTATION_TYPE'),
		dataIndex: 'presentationType',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				return getCommonTranslation(value);
			}
		}
	},{
		header:  getCommonTranslation('PRESENTATION_SUB_TYPE'),
		dataIndex: 'presentationSubType',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				return getCommonTranslation(value);
			}
		}
	},{
		header:  getCommonTranslation('BUZZ_CAMPAIGN_CODE'),
		dataIndex: 'code',
		flex:0.8,
		sortable:true
	},{
		header:  getCommonTranslation('CAMPAIGN_NAME'),
		dataIndex: 'campaignName',
		flex:1.2,
		sortable:true
	},{
		header:  getCommonTranslation('STATUS'),
		dataIndex: 'status',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				return getCommonTranslation(value);
			}
		}
	},{
		header:  getCommonTranslation('SCHOOL'),
		dataIndex: 'noOfSchoolCount',
		flex:.8,
		sortable:true,
		renderer:function(value,meta,record){
			var noOfSchoolCount = record.get('noOfSchoolCount');
			if(!isNullOrEmpty(value) && value > 0){
				return '<a href=#>'+value+'</a>';
			}
			else{
				return '-';
			}
		}
	},{
		header:  getCommonTranslation('OWNER'),
		dataIndex: 'ownerPrintName',
		flex:1,
		hidden:true,
		sortable:true,
		/*renderer:function(value,meta,record){
			return value.value;
		}*/
	},{
		header:  getCommonTranslation('VENUE'),
		dataIndex: 'venue',
		flex:1,
		hidden:true,
		sortable:true
	},{
		header:  getCommonTranslation('CREATED_ON'),
		dataIndex: 'createdOn',
		flex:1,
		hidden:true,
		sortable:true,
		renderer : function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('START_DATE'),
		dataIndex: 'startDate',
		flex:1,
		sortable:true,
		renderer : function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('END_DATE'),
		dataIndex: 'endDate',
		flex:1,
		sortable:true,
		renderer : function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('NUMBER_OF_LEAD_CAPTURED'),
		dataIndex: 'noOfEnquiryCount',
		flex:1,
		sortable:false,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				return '<a href=#>'+value+'</a>';
			}
			else{
				return '-';
			}
		}
	},{
		header:  getCommonTranslation('CONVERSION_RATE'),
		dataIndex: 'conversionRate',
		flex:1,
		sortable:false
	}]
});
