/**
 * Ram Krishan Yadav
 */
Ext.define('Academia.view.campaignnew.CampaignNewSchoolALGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.campaignnewSchoolalgrid',
    store: 'campaignnew.CampaignNewSchoolALStore',
    // title: getCommonTranslation("SHOOL_DETAILS"),
    border: true,
    autoScroll: false,
    frame: false,
    width: '100%',
    viewConfig: {
        stripeRows: false
    },
    selModel: {
        mode: 'MULTI',
        allowDeselect: false,
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'campaignnew.CampaignNewSchoolALStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    columns: [{
        header: getCommonTranslation("BRAND_CAMPUS"),
        dataIndex: 'academyDisplayName',
        flex: .1,
        sortable: false
    }, {
        header: getCommonTranslation("SCHOOL"),
        dataIndex: 'schoolName',
        flex: .1,
        sortable: false
    }, {
        header: getCommonTranslation("SCHOOL_PRIORITY"),
        dataIndex: 'schoolPriority',
        flex: .1,
        sortable: false,
        renderer: function(val) {
        	if(!isNullOrEmpty(val)){
        		return getCommonTranslation(val);
        	}else{
        		return "-";
        	}
        }
    }]
});