/**
 * @author Harshit Satya
 */
Ext.define('Academia.view.committee.committee.AlumniCommitteeGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.alumnicommitteegrid',
	store: 'committee.committee.AlumniCommitteeGridStore',
	title: getAlumni("LIST_OF_ALUMNI_COMMITTEE"),
	border: true,
	frame:false,
    isGridConfigurable: true,
	enableColumnHide: false,
	hidden: true,
	refreshStoreData:true,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'committeetabstructure':1
		}
	},
	/*selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},*/
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'committee.committee.AlumniCommitteeGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		disabled:true,
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		disabled:true,
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		disabled:true,
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text: getExaminationTranslation('APPLY_TO'),
			itemId: 'btnApplyTo',
		},{
			text:getCommonTranslation('ADD_MEETING'),
			itemId:'addMeetingBtn'
		},{
			text:getCommonTranslation('SEND_MESSAGE'),
			itemId:'sendMessageBtn'
		}],
		listeners: { click: function() { this.showMenu(); } }
	}],
	columns: [/*{
		header:  getExaminationTranslation('ID'),
		dataIndex: 'id',
		flex:.1,
		hidden:true,
		sortable:true
	},*/{
		header:  getAlumni("COMMITTEE_CODE"),
		dataIndex: 'committeeCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("COMMITTEE_TYPE"),
		dataIndex: 'committeeTypeValue',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("COMMITTEE_NAME"),
		dataIndex: 'committeeName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("COMMITTEE_CO_ORDINATOR"),
		dataIndex: 'committeeCoordinatorName',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.committeeCoordinatorName)){
				return record.data.committeeCoordinatorName;
			} else {
				return '-';
			}
		}
	},{
		header:  getCommonTranslation("DESCRIPTION"),
		dataIndex: 'description',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.description)){
			    return record.data.description;
			} else {
				return '-';
			}
		}
	}]
});
