/**
 * @author Vishal Joshi
 */
Ext.define('Academia.view.committee.committee.CommitteeGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.committeegrid',
	store: 'committee.committee.CommitteeGridStore',
	title: getCommonTranslation("LIST_OF_COMMITTEE"),
	border: true,
	frame:false,
	refreshStoreData:true,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'committeetabstructure':1
		}
	},
	/*selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},*/
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'committee.committee.CommitteeGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text: getExaminationTranslation('APPLY_TO'),
			itemId: 'btnApplyTo',
		},{
			text:getCommonTranslation('ADD_MEETING'),
			itemId:'addMeetingBtn'
		},{
			text:getCommonTranslation('SEND_MESSAGE'),
			itemId:'sendMessageBtn'
		}],
		listeners: { click: function() { this.showMenu(); } }
	}],
	columns: [/*{
		header:  getExaminationTranslation('ID'),
		dataIndex: 'id',
		flex:.1,
		hidden:true,
		sortable:true
	},*/{
		header:  getCommonTranslation("COMMITTEE_CODE"),
		dataIndex: 'committeeCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("COMMITTEE_TYPE"),
		dataIndex: 'committeeTypeValue',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("COMMITTEE_NAME"),
		dataIndex: 'committeeName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("COMMITTEE_CO_ORDINATOR"),
		dataIndex: 'committeeCoordinatorName',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.committeeCoordinatorName)){
				return record.data.committeeCoordinatorName;
			} else {
				return '-';
			}
		}
	},{
		header:  getCommonTranslation("NO_OF_PARTICIPANT"),
		dataIndex: 'totalParticipants',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.totalParticipants)){
				return '<a href=#>'+record.data.totalParticipants+'</a>';
			}
		}
	},{
		header:  getProgramandcourseTranslation("ACADEMY_LOCATION"),
		dataIndex: 'committeeAcademyLocations',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.committeeAcademyLocations) && record.data.committeeAcademyLocations.length>0) {
			    return '<a href=#>'+record.data.committeeAcademyLocations.length+'</a>';
			} else {
				return '-';
			}
		}
	},{
		header:  getCommonTranslation("DESCRIPTION"),
		dataIndex: 'description',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.description)){
			    return '<a href=#>View</a>';
			} else {
				return '-';
			}
		}
	}]
});
