/**
 * This is the Academy Location Program Batch SeatType Dependent Dropdown Component.
 * 
 * This component will be used for selection of the Academy Location Program Batch SeatType
 * based on the selection of the previous dropdowns value.
 * 
 * use the "xtype: academylocationprogrambatchseattypeform" to integrate it in any screen.<br>
 * user checkUserAccess==true for loading data according to user right
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.common.AcademyLocationProgramBatchSeatTypeForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.academylocationprogrambatchseattypeform',
    margin: 0,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype: 'nestedJsonCombo',
            name: 'academy',
            itemId: 'academyCombo',
            displayField: 'value',
            valueField: 'id',
            queryMode: 'remote',
            allowBlank: false,
            fieldLabel: getCommonTranslation('ACADEMY'),
            listeners: {
                select: function(combo, records, eOpts) {
                	var form = combo.up('form');
                	var locationCombo = form.down('#locationCombo');
                	form.loadDependentCombo(locationCombo, records, 'academyId');
                },
                render: function(combo) {
                	 // var storeUrl='Academia.store.common.AcademyStore';
                		var storeUrl='Academia.store.common.AcademyByUserStore';
                	  if(this.up('form').checkUserAccess==true){
                		  storeUrl='Academia.store.common.AcademyByUserStore';
                	  }
                	  var store = Ext.create(storeUrl);
                	  combo.bindStore(store);
                }
            }
        }, {
        	xtype: 'nestedJsonCombo',
            name: 'location',
            itemId: 'locationCombo',
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            allowBlank: false,
            fieldLabel: getCommonTranslation('LOCATION'),
            listeners: {
                select: function(combo, records, eOpts) {
                	var form = combo.up('form');
                    var academyId = form.down('#academyCombo').getValue();
                    var programCombo = form.down('#programCombo');
                    form.loadDependentCombo(programCombo, records, 'locationId', 'academyId', academyId);
                },
                render: function(combo) {
              	  var storeUrl='Academia.store.common.LocationByUserStore';
              	  if(this.up('form').checkUserAccess==true){
              		  storeUrl='Academia.store.common.LocationByUserStore';
              	  }
              	  var store = Ext.create(storeUrl);
              	  combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype: 'nestedJsonCombo',
            name: 'program',
            itemId: 'programCombo',
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            allowBlank: false,
            fieldLabel: getCommonTranslation('PROGRAM'),
            listeners: {
                select: function(combo, records, eOpts) {
                	var form = combo.up('form');
                	var batchCombo = form.down('#batchCombo');
                	form.loadDependentCombo(batchCombo, records, 'id');
                },
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.ProgramsByAcademyIdLocationId');
                    combo.bindStore(store);
                }
            }
        }, {
        	xtype: 'nestedJsonCombo',
            name: 'batch',
            itemId: 'batchCombo',
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            allowBlank: false,
            fieldLabel: getCommonTranslation('BATCH'),
            listeners: {
                select: function(combo, records, eOpts) {
                	var form = combo.up('form');
                	var seatTypeCombo = form.down('#seatTypeCombo');
                	form.loadDependentCombo(seatTypeCombo, records, 'batchId');
                },
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype: 'nestedJsonCombo',
            name: 'seatType',
            itemId: 'seatTypeCombo',
            displayField: 'seatTypeName',
            valueField: 'seatTypeId',
            progBatchSeatConfigId: null,
            fieldLabel: getCommonTranslation('SEAT_TYPE'),
            queryMode: 'local',
            autoload: false,
            allowBlank: false,
            listeners: {
            	select: function(combo, records, eOpts) {
            		combo.progBatchSeatConfigId =records[0].get('id');
            	},
            	render: function(combo) {
                    var store = Ext.create('Academia.store.common.SeatTypesByBatchId');
                    combo.bindStore(store);
                }
            }
        }]
	}],

    /**
     * Method to load the next combo based on the selection of the previous combo value.
     * @param {Object} dependentCombo is the reference of the next dropdown which should be populated with values.
     * @param {Object} selectedRecord is the record of the previous dropdown which is selected.
     * @param {Object} parameter is the value that should be attached in the url.
     * @param {Object} extraParameter (optional) If there is any extra parameter to be sent for loading the
     *  dependent dropdown.
     * @param {Object} extraParamValue (optional) The value of the extraParam that is sent for loading the store.
     */
    loadDependentCombo: function(dependentCombo, selectedRecord, parameter, extraParameter, extraParamValue) {
    	this.resetOtherDropdowns(dependentCombo);
        dependentCombo.clearValue();
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = selectedRecord[0].get('id');
        var url = store.getProxy().proxyConfig.api.read;
        if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
            url = url.concat('?' + parameter + '=' + id);
        } else {
            url = url.concat('?' + parameter + '=' + id);
            url = url.concat('&' + extraParameter + '=' + extraParamValue);
        }
        store.getProxy().api.read = url;
        store.reload();
    }, 
    
    /**
     * code to reset other dropdowns based on the selection of any dropdown which is previous in the hierarchy.
     * eg: if all the dropdowns are loaded and the Academy is changed then subsequent dropdowns should be
     * changed accordingly, so their value is cleared and reset and reloaded.
     * @param: {Object} combo The reference of the dropdown which is the dependent/next combo. 
     */
    resetOtherDropdowns: function(combo) {
    	var container = combo.up('form');
    	switch(combo.name) {
    	case 'academy':
    		break;
    	case 'location':
    		this.clearCombo(combo);
    		programCombo = container.down('combo[name=program]');
    		this.clearCombo(programCombo);
    		batchCombo = container.down('combo[name=batch]');
    		this.clearCombo(batchCombo);
    		seatTypeCombo = container.down('combo[name=seatType]');
    		this.clearCombo(seatTypeCombo);
    		break;
    	case 'program':
    		this.clearCombo(combo);
    		batchCombo = container.down('combo[name=batch]');
    		this.clearCombo(batchCombo);
    		seatTypeCombo = container.down('combo[name=seatType]');
    		this.clearCombo(seatTypeCombo);
    		break;
    	case 'batch':
    		this.clearCombo(combo);
    		seatTypeCombo = container.down('combo[name=seatType]');
    		this.clearCombo(seatTypeCombo);
    		break;
    	case 'seatType':
    		this.clearCombo(combo);
    		break;
    	}
	},
	
	/**
	 * function to clear the combo store, clear its existing value
	 *  and remove all the records from the store.
	 *  @param {Object} the reference of the combo whose store should be cleared.
	 */
	clearCombo: function(combo) {
		combo.clearValue();
		combo.store.removeAll();
	},
	reset:function(){
		var academyCombo =this.down('combo[name=academy]');
		academyCombo.clearValue();
		var locationCombo =this.down('combo[name=location]');
		this.items.items[0].resetOtherDropdowns(locationCombo);
	}
});
