/**
 * This component will be used for adding the records in a checklist.
 * use the "xtype: checklistcomponent" to integrate it in any screen.
 * TODO: theming for the selected records necessary.
 */
Ext.define('Academia.view.common.CheckListComponent', {
	extend : 'Ext.form.Panel',
	alias : 'widget.checklistcomponent',
	
	items: [{
		xtype: 'fieldcontainer',
		layout: {
			type: 'hbox'
		},
		defaults: {
            labelAlign: 'top'
        },
		items: [{
	        	xtype: 'multiselectcombofield',
	        	fieldLabel: getCommonTranslation('SELECT_CHECKLIST_ITEMS'), 
	        	store: 'Academia.store.common.Checklist',
	            displayField: 'value',
	            valueField: 'id',
	            queryMode: 'local',
	    		typeAhead: true,
	    		width: '500px',
	    		//height: '30px',
	    		//inputHeight: '30px',
	            editable: true,
	            //allowBlank: false,
	            name: 'checkListCombo'
		}, {
			xtype: 'button',
            itemId: 'btnAddDocumentsToCheckList',
            text: getCommonTranslation('ADD_TO_CHECKLIST'),                       
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true,
            style: {
            	marginTop : '30px'	
            },
			//Uncomment if a listing of the checklist items is required
            handler: function() {
            	var multiselectcombo = this.previousSibling();
           		var valueModels = multiselectcombo.getValueModels();
           		var targetContainer = this.up().nextSibling();
           		targetContainer.removeAll();
           		Ext.each(valueModels, function(value) {
           			var item = new Ext.toolbar.TextItem({
           				text: value.get('value')
           			});
           			targetContainer.add(item);
           		});
            }
		}]
/*	}, {
		xtype: 'fieldset'*/
	}]
	
});