/**
 *  This Combo is Live search combo box 
 */
Ext.define('Academia.view.common.LiveSearchCombo',{
	extend:'Academia.view.common.NestedJsonCombo',
	alias:'widget.livesearchcombo',
	displayField: 'value', 
	valueField: 'id', 
	typeAhead: false,
	triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	queryParam : 'term',
	minChars: 3,
	maskRe: /[^%]/,
	remoteFilter: true,
	forceSelection: true,
	listConfig: {
		loadingText:  getCommonTranslation('SEARCHING'),
		emptyText:  getCommonTranslation('NO_MATCH'),
		listeners: {
			beforeshow: function(picker) {
				picker.minWidth = picker.up('combobox').getSize().width;
			}
		}
	},
	listeners: {
		change: function(obj, newValue, oldValue, opt){
			if(!Ext.isObject(newValue)){
				if(!Ext.isNumber(newValue) && newValue && newValue.match(/%/)){
					obj.setValue(oldValue);
				}
			}
		}
	},
	buildStore: function() {
		var comboStore = null;
		if(this.store!=undefined || this.store!=null){
			try{
				comboStore = Ext.create(this.store);
				}
				catch(e){
				comboStore = Ext.getStore(this.store);
				}
		}else{
			comboStore = Ext.create('Academia.store.common.LiveSearchCombos');
		}
	    return comboStore;
	},
	buildTemplate: function() {
		var displayTpl = null;
		if(this.displayTpl!=undefined || this.displayTpl!=null){
			displayTpl =  this.displayTpl;
		}else{
			displayTpl =  new Ext.XTemplate(
					'<tpl for="."between=" ">',
					//'{[typeof values === "string" ? values : values["salutation.value"]]}'+
					'{[typeof values === "string" ? values : values["firstName"]]}' + ' '+
					'{[typeof values === "string" ? values : values["lastName"]]}' + ' [' +
					'{[typeof values === "string" ? values : values["code"]]}'+']' +
					//'{[typeof values === "string" ? values : values["department"]]}'+
					'</tpl>'
			);
		}
	    return displayTpl;
	},
	
	initComponent: function() {
	        var this$ = this;
	        var store = this$.buildStore();
	        var displayTpl = this$.buildTemplate();
	        Ext.apply(this$, {
	            store: store,
	            displayTpl: displayTpl
	        });
	        this$.callParent(arguments);
	}
});

