/**
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.completion.setup.MapCertificateWithTransactionForm', {
    extend: 'Ext.window.Window',
    alias: 'widget.mapcertificatewithtransactionform',
    title: getCompletionModuleTranslation('MAP_CERTIFICATE_WITH_TRANSACTION_TYPE'),
    modal: true,
    resizable: false,
    autoScroll: true,
    frame: true,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'form',
        items: [{
            xtype: 'hidden',
            itemId: 'map_hidden_field',
            name: 'id'
    	}, {
	        xtype: 'hidden',
	        name: 'progBatchSeatConfId'
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'hidden',
                name: 'program'
            }, {
                xtype: 'textfield',
                fieldLabel: getCompletionModuleTranslation('PROGRAM'),
                readOnly: true,
                submitValue: false,
                name: 'programName'
            }, {
                xtype: 'hidden',
                name: 'batch'
            }, {
                xtype: 'textfield',
                fieldLabel: getCompletionModuleTranslation('BATCH'),
                
                readOnly: true,
                submitValue: false,
                name: 'batchName'
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'hidden',
                name: 'seatType'
            }, {
                xtype: 'textfield',
                fieldLabel: getCompletionModuleTranslation('SEAT_TYPE'),
                
                readOnly: true,
                submitValue: false,
                displayField: 'transactionType.value',
                name: 'seatTypeName'
            }, {
                xtype: 'hidden',
                name: 'transactionType'
            }, {
                xtype: 'textfield',
                fieldLabel: getCompletionModuleTranslation('TRANSACTION_TYPE'),
                
                readOnly: true,
                submitValue: false,
                displayField: 'transactionType.value',
                name: 'transactionTypeName'
            }]
        }, {
            xtype: 'itemselector',
            hidden: true,
            //submitValue: false,
            labelAlign: 'top',
            labelWidth: 120,
            margin : 0,
            width: 463,
            name: 'transactionTypeChecklistItems',
            itemId: 'checklistItems',
            fieldLabel: getCompletionModuleTranslation('CHECKLIST_ITEM'),
            maxHeight:400,
            autoScroll:true,
            imagePath: '../ux/css/images/',
            store: 'Academia.store.completion.setup.CKItemsMappedWithTransactionType',
            displayField: 'checklistItem.value',
            valueField: 'checklistItem.id',
            editable: false,
            fromTitle: getCompletionModuleTranslation('AVAILABLE_ITEM'),
            toTitle: getCompletionModuleTranslation('APPLICABLE_ITEM'),
            msgTarget: 'side',
            delimiter: null,
            buttons: ['top', 'add', 'remove', 'bottom']
        }, {
            xtype: 'itemselector',
            labelAlign: 'top',
            labelWidth: 120,
            margin: 0,
            width: 463,
            name: 'transactionTypeCertificates',
            itemId: 'certificates',
            fieldLabel: getCompletionModuleTranslation('CERTIFICATE'),
            maxHeight: 400,
            autoScroll: true,
            store: 'Academia.store.completion.setup.CertificatesMappedWithTransactionType',
            displayField: 'value',
            valueField: 'id',
            editable: false,
            fromTitle: getCompletionModuleTranslation('AVAILABLE_ITEM'),
            toTitle: getCompletionModuleTranslation('APPLICABLE_ITEM'),
            msgTarget: 'side',
            buttons: ['top', 'add', 'remove', 'bottom']
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SUBMIT'),
                itemId: 'certificateSubmitButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE

            }]
        }]
    }]
});