/**
 * By Rajkumar
 */
Ext.define('Academia.view.course.NoOfProgAssoGrid', {
	 extend: 'Ext.form.Panel',
	alias : 'widget.noofprogassogrid',
	border: true,
	autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
		    store : 'course.NoOfProgAssoGridStore',
		    displayInfo : true
		} ]
	    }],
	items:[{
		xtype: 'grid',
		store : 'course.NoOfProgAssoGridStore',
		columns : [{
			header : 'ID',
			hidden : true,
			dataIndex:'id'
		},{
			header :getCommonTranslation('PROGRAM_CODE'),
			dataIndex : 'programCode',
			flex : 1

		}, {
			header : getCommonTranslation('PROGRAM_NAME'),
			dataIndex : 'programName',
			flex : 1	

		}, {
			header : getCommonTranslation('BATCH'),
			dataIndex : 'batchName',
			flex : 1
		}, {
			header : getCommonTranslation('PROGRAM_PERIODS'),
			dataIndex : 'programPeriod',
			flex : 1

		}, {
			header : getCommonTranslation('OPTIONAL_MENDATORY'),
			dataIndex : 'whetherOptional',
			flex : 1,
			renderer : function(value){
				if(value){
					return getCommonTranslation('MANDATORY');
				}else{
					return getCommonTranslation('OPTIONAL');
				}}
		}]
	}]	
});
