/**
 * @author Akshay Sharma
 */
Ext.define('Academia.view.course.NoOfRegCourseGrpAssoGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.noofregcoursegrpassogrid',
	border : true,
	autoScroll : false,
	title:getProgramandcourseTranslation('REGULAR_GROUP_ASSOCIATED'),
	store : 'course.NoOfRegCourseGroupAssoGridStore',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'course.NoOfRegCourseGroupAssoGridStore',
			displayInfo : true
		} ]
	} ],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments); 
	},
	columns : [ {
		header : 'ID',
		hidden : true,
		dataIndex : 'id'
	}, /*{
		header :getCommonTranslation('PROGRAM_CODE'),
		dataIndex : 'programCode',
		flex : 1

	}, {
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batch',
		flex : 1

	}, */{
		header : getCommonTranslation('COURSE_GROUP'),
		dataIndex : 'courseGroupName',
		flex : 1
	}, /*{
		header : getCommonTranslation('PROGRAM_PERIODS'),
		dataIndex : 'programPeriod',
		flex : 1

	},*/ {
		header : getCommonTranslation('OPTIONAL_MENDATORY'),
		dataIndex : 'whetherMandatory',
		flex : 1,
		renderer : function(value){
			if(value){
				return getCommonTranslation('MANDATORY');
			}else{
				return getCommonTranslation('OPTIONAL');
			}
		}
	}, {
		header : getCommonTranslation('PROGRAMS_ASSOCIATED'),
		dataIndex : 'noOfAssociatdPrograms',
		flex : 1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	}]
});
