/**
 * @author Rajkumar.Patidar
 */
Ext.define('Academia.view.course.courseEquivalence.CourseEquivalenceGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.courseequivalencegrid',
	store : 'course.courseequivalence.CourseEquivalenceStore',
	border: true,
	frame: false,
    refreshStoreData: true,
	cls: 'horizontalScrollingFixed',
	/*sortableColumns:false,
	enableColumnHide: false,
	enableColumnMove: false,
	enableColumnResize: false,*/
	autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'course.courseequivalence.CourseEquivalenceStore',
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype : 'button',
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph : ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH	
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],

	columns : [/*{
		hidden : true,
		dataIndex : 'id'
	},*/{
		header : getCommonTranslation('EQUIVALENT_COURSE_CODE'),
		dataIndex : 'courseEquivalentCode',
		flex : 1

	}, {
		header : getCommonTranslation('EQUIVALENT_COURSE_NAME'),
		dataIndex : 'courseEquivalentName',
		flex : 1	

	},
	{
		header : getCommonTranslation('STATUS'),
		dataIndex : 'whetherActive',
		flex : 1,
		renderer : function(value){
			if(value){
				return getCommonTranslation('ACTIVE');
			}else{
				return getCommonTranslation('INACTIVE');
			}}
	},
	{
		header : getCommonTranslation('COURSE_EQUIVALENCE_ALIAS'),
		dataIndex : 'courseEquivalenceAlias',
		flex : 1,
		renderer : function(value){
			if(value!=null){
				return value;
			}}
	}
	]

});
