/**
 * @author Phool Singh Gour
 */
Ext.define('Academia.view.course.coursegroup.CourseGroupQuickSearchForm', {
	extend: 'Ext.form.FormPanel',
    alias: 'widget.coursegroupquicksearchform',
    autoScroll: true,
    frame: false,
	cls:'customSearchPanel',
    layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    items: [{
       /* xtype: 'form',
        width: '100%',
        items: [{*/
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
	                xtype: 'customcombobox',
	                name: 'courseGroupCode',
	                itemId:'quick_search_courseGroupCode',
	                fieldLabel: getCommonTranslation('COURSE_GROUP_CODE_NAME'),
	                store:'course.coursegroup.AllCourseGroupStore',
	                valueField: 'code',
	    			displayField: 'valueCode',
	    			queryParam:'qry',
	    			minChars:3,
	    			allowBlank: true,
	    			typeAhead:false,
	                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	                forceSelection:true,
	    			  listConfig: {
	    				  listeners: {
	    						beforeshow: function(picker) {
	    							picker.minWidth = picker.up('combobox').getSize().width;
	    						}
	    					},
	    	                loadingText: getCommonTranslation('SEARCHING'),
	    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    	                getInnerTpl: function() {
	    	                    return '<div class="search-item">' +
	    	                        '{value}' +
	    	                    '</div>';
	    	                }
	    	            }
//	                translationKey:'COURSE_GROUP_CODE'
	            },/* {
	                xtype: 'textfield',
	                name: 'courseGroupName',
	                itemId:'quick_search_courseGroupName',
	                fieldLabel: getCommonTranslation('COURSE_GROUP_NAME'),
//	                translationKey:'COURSE_GROUP_NAME'
	            },*/{
	    			xtype: 'customcombobox',
	    			name:'groupType',
	    			itemId:'groupTypeId',
	    			store:'course.coursegroup.CourseGroupTypeStore',
	    			fieldLabel:getCommonTranslation('COURSE_GROUP_TYPE'),
	    			valueField: 'id',
	    			displayField: 'value',
	    			forceSelection:true,
	    			width:226,
	    			typeAhead:false,
	    			allowBlank:false,
	    			queryMode:'local',
					anyMatch : true
	    			/*listConfig: {
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    				getInnerTpl: function() {
	    					return '<div class="search-item">' +
	    					'{value}' +
	    					'</div>';
	    				},
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				},
	    			}*/
	    		}]
        	},
        	{
                xtype: 'fieldcontainer',
                layout: 'hbox',
                defaults: {
                    width: 226,
                    labelAlign: 'top'
                },
                items: [{
                	xtype: 'customcombobox',
                	width:460,
                    name: 'courseName',
                    fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
//    		        translationKey:'COURSE_CODE_NAME',
                	itemId:'courseNameQuickFiltr',
                	store:'coursetransaction.studymaterialdistribution.CoursesAllSmartSearch',
        			valueField: 'id',
        			displayField: 'value',
        			queryParam:'qry',
        			minChars:3,
        			allowBlank: true,
        			typeAhead:false,
                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                    forceSelection:true,
        			  listConfig: {
        				  listeners: {
        						beforeshow: function(picker) {
        							picker.minWidth = picker.up('combobox').getSize().width;
        						}
        					},
        	                loadingText: getCommonTranslation('SEARCHING'),
        	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        	                getInnerTpl: function() {
        	                    return '<div class="search-item">' +
        	                        '{value}' +
        	                    '</div>';
        	                }
        	            }
                	}]
            	},{
            xtype: 'fieldcontainer',
            width: 'auto',
            
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'courseGroupQuickSearchFormId',
                buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            },{
                xtype: 'button',
                text: getCourseTxCommonTranslation('RESET'),
                itemId: 'resetBtn',
                buttonAlign: 'left',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

  //  }]
});