/**
 * Rajkumar
 * 
 */
Ext.define('Academia.view.course.requisite.CourseRequisiteForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.courserequisiteform',
	columns: 3,
	title: getProgramandcourseTranslation('SUBJECT_REQUISITES'),
	autoScroll: false,
	frame: false,
	method: 'POST',
	standardSubmit: false,
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM,
		marginTop: 5
	},
	defaults: {
		width: 226,
		labelAlign: 'top'
	},
	plugins : "formlabelrequired",
	items: [{
		xtype: 'fieldset',
		collapsible : true,
		collapsed: false,
		title: getProgramandcourseTranslation('PRE_REQUISITES'),
		titleCollapse: true,
		margin: '0 0 0 0',
		padding: '0 0 0 0',
		width: '100%',
		itemId : 'coursePreRequisiteItemId',
		style: {
			marginTop: '33px !important'
		},
		items: [{
			xtype: 'hidden',
			itemId:'preRequisiteId',
			name: 'preRequisiteId'
		},{
	        xtype: 'textfield',
	        name: 'hiddenTextFieldForDisableSaveBtn',
	        itemId: 'hiddenTextFieldForDisableSaveBtnItemId',
	        hidden:true,
	    },{
        	xtype: 'courseprerequisitecriteriaform',
			itemId: 'coursePreGroupItemId',
			style :{
				marginLeft : '5px',
				marginBottom:'0px'
			}
		},{
			xtype:'panel',
			itemId:'coursePreChildGroupItemId',
			items:[]
		},{
			xtype:'textarea',
			itemId:'additionalCriteriaPre',
			name:'additionalCriteriaPre',
			labelAlign: 'top',
			width: 460,
			align : 'left',
			fieldLabel: getProgramandcourseTranslation('ADDITIONAL_CRITERIA'),
		    maxLength:9999,
		   
		}]
	},
	{
		xtype: 'fieldset',
		collapsible : true,
		collapsed: true,
		title: getProgramandcourseTranslation('CO_REQUISITES'),
		titleCollapse: true,
		margin: '0 0 0 0',
		padding: '0 0 0 0',
		width: '100%',
		itemId : 'courseRequisiteItemId',
		style: {
			marginTop: '33px!important'
		},
		items: [{
			xtype: 'hidden',
			itemId:'courseRequisiteId',
			name: 'courseRequisiteId'
		},{
			xtype: 'multiselectcombofield',
			name: 'course',
			itemId: 'courseId',
			autoloadStore: false,
			width: 460,
			store:Ext.create('Academia.store.course.UserAccessibleALChildCourseStore'),
			displayField : 'valueCode',
			valueField : 'id',
			queryParam:'courseName',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			queryMode:'remote',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
						});
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},
		{
			xtype:'textarea',
			itemId:'additionalCriteriaCo',
			name:'additionalCriteriaCo',
			labelAlign: 'top',
			width: 460,
			align : 'left',
			fieldLabel: getProgramandcourseTranslation('ADDITIONAL_CRITERIA'),
			maxLength:9999,
		}
		
		]
	},{
		xtype: 'fieldset',
		collapsible : true,
		collapsed: true,
		title: getProgramandcourseTranslation('MUTUALLY_EXCLUSIVE'),
		titleCollapse: true,
		margin: '0 0 0 0',
		padding: '0 0 0 0',
		width: '100%',
		itemId : 'courseMutuallyExclusiveItemId',
		style: {
			marginTop: '33px!important'
		},
		items: [{
			xtype: 'hidden',
			itemId:'courseMutuallyExclusiveId',
			name: 'courseMutuallyExclusiveId'
		},{
			xtype: 'multiselectcombofield',
			name: 'courseMutually',
			itemId: 'courseMutuallyId',
			autoloadStore: false,
			width: 460,
			store:Ext.create('Academia.store.course.UserAccessibleALChildCourseStore'),
			displayField : 'valueCode',
			valueField : 'id',
			queryParam:'courseName',
			minChars:3,
			typeAhead:true,
			maxLength:250000,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			queryMode:'remote',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
						});
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]},
		{ 
			xtype:'fieldcontainer',
			width:'auto',
			layout : 'hbox',
			items: [{
				xtype: 'button',
				text: getMessagingModuleTranslation('CLEAR_SEARCH'),
				itemId: 'resetCourseRequisiteButton',
				buttonAlign: 'right',
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'courseRequisiteSaveButtonId',
				ui : 'CustomBtnThird',
		   		scale : CONSTANTS.BUTTONSIZE
			}]
		}]
});
