/**
 * @author Aksahy Sharma
 * 
 */
Ext.define('Academia.view.coursesessiondiary.CourseSessionDiaryDocumentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.coursesessiondiarydocumentgrid',
	store :'coursesessiondiary.CourseSessionDiaryDocument',
	border: true,
	autoScroll: false,
	//height:'80%',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	title : getProgramandcourseTranslation('LIST_OF_DOCUMENTS'),
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'coursesessiondiary.CourseSessionDiaryDocument',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
		this.callParent(arguments);
	},
	tbar: ['->',{
		xtype : 'button',
		itemId : 'downloadDocumentItemId',
		tooltip : getCommonTranslation('DOWNLOAD_ALL'),
		text : getCommonTranslation('DOWNLOAD_ALL'),
		formBind:true,
	}/*,{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH		
	}*/],
	columns :[{
		header : getCommonTranslation('S_NO'),
		xtype: 'rownumberer',
		flex: 0.5
	},{
		header : getCommonTranslation('DOCUMENTS'),
		dataIndex : 'documentName',
		flex:1,
		renderer:function(value,rec){
			return value;
		}
	},{
		header : getCommonTranslation('UPLOADED_ON'),
		dataIndex : 'submissionDate',
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
	}]
});