/**
 * @author Ravi Choudhary
 * 
 */
Ext.define('Academia.view.coursesessiondiary.CourseSessionDiaryForm',{
//	extend:'Academia.view.common.DynamicFieldForm',
	extend: 'Academia.view.common.CustomFieldForm',
	customFieldEntity:CONSTANTS.COURSE_SESSION_DIARY,
	alias : 'widget.coursesessiondiaryform',
	autoScroll: true,
	cls:'horizontal-scrolling-fix',
	bodyPadding:'10 10 10 10',
	columns: 3,
	frame:true,
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	itemId:'createcourseSessionDiaryformItemId',
	plugins : "formlabelrequired",
	method: 'POST',
	/*items: [{
		xtype: 'fieldcontainer',
		layout: 'vbox',
		defaults: {
			labelAlign: 'top',
			//width: 226
		},*/
		
		items : [{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'hidden',
				name: 'id'
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
				name : 'courseId',
				itemId : 'courseId',
				store : 'attendance.AssignedCoursesFacultyStore',
				displayField : 'courseCodeName',
				valueField : 'courseId',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				allowBlank:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('COMPONENT'),
				name : 'componentId',
				itemId : 'componentId',
				store:'course.coursecomponent.CourseComponentCouseWise',
				displayField:'componentTypeName',
				valueField : 'id',
				typeAhead : true,
				disable:true,
				forceSelection : true,
				hidden:true,
				allowBlank:false
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
				name : 'courseVariantId',
				itemId : 'courseVariantId',
				store:'course.coursevariants.ParameterCourseVariantStore',
				displayField : 'courseVariantCode',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank:false,
				disabled:true,
			}]
		},{
			xtype: 'fieldcontainer',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			width:'auto',
			items : [{
				xtype : 'customcombobox',
				width: 226,
				labelAlign: 'top',
				fieldLabel : getCourseTxCommonTranslation('FACULTY'),
				itemId:'facultyId',
				name : 'facultyId',
				store:'attendance.AttendanceFacultyList',
				displayField : 'facultyName',
				valueField : 'facultyId',
				allowBlank:false,
//				typeAhead : true,
				forceSelection : true,
				hidden:false
			},{
				xtype: 'datefield',
				name: 'sessionDate',
				//--submitFormat: 'd-m-Y',
				itemId:'courseSessionDateId',
				fieldLabel: getCommonTranslation('DATE'),
//				value: new Date(),
				maxValue:new Date(),
				allowBlank:false,
				editable : false,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			width:'auto',
			items: [{
				xtype: 'customcombobox',
				name: 'timeSlot',
				itemId:'timeSlot',
//				width: 460,
				labelAlign: 'top',
				fieldLabel: getCourseTxCommonTranslation('TIME_SLOT'),
//				store:'coursetransaction.sectioncoursecoverageplan.mastertimetable.PeriodsByCalendar',
				displayField:'code',
				valueField:'id',	
				autoloadStore: false,
				disabled:true,
				typeAhead:true,
				forceSelection:true,
//				hidden:true,
				listeners  :{
	            	render : function(combo){
	            		  var store=Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.MasterTimeTableForVariant');
	            		  combo.bindStore(store)
	            	}
	            }
			},{
				xtype : 'textfield',
				name : 'session',
				itemId : 'sessionId',
				fieldLabel : getCommonTranslation('SESSION_NUMBER'),
				minValue : 0,
				mouseWheelEnabled :false,
				hideTrigger :true,
				allowExponential:false,
				allowDecimals:false,
				editable:true,
				allowBlank:false,
				vtype:'allowNumberAndHyphen'
			}]
		},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults : {
				width : 80
			},
			items: [{
				xtype: 'displayfield',
				fieldLabel: getCommonTranslation('PUBLISH_TO'),
//				margin: '8 0 8 0',
			},{
				xtype: 'checkboxfield',
				boxLabel: getCommonTranslation('STUDENTS'),
				name: 'publishToStudent',
				itemId: 'chkStudentBox',
				checked:true,
//			    margintop: '16px',
//				margin:'0 5 0 5',
				allowBlank:true,
			}, {
				xtype: 'checkboxfield',
				boxLabel: getCommonTranslation('PARENTS'),
				name: 'publishToParent',
//				marginTop:'16px',
				itemId: 'chkParenBox',
				allowBlank:true,
				checked:true
			}]
		},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults : {
				labelAlign : 'top'
			},
			items: [{
				xtype: 'displayfield',
				fieldLabel: getCommonTranslation('DISPLAY_TO_PORTALS')
			},{
				xtype : 'datefield',
				fieldLabel : getCommonTranslation('FROM_DATE'),
				name : 'fromTime',
				itemId:'courseSessionFromDateId',
				endDateField : 'courseSessionToDateId',
				vtype : 'daterange',
				minValue:new Date(),
				preventMark:true,
				listeners: {
					render: function(field) {
						field = dateFormatRender(field);						
						field.setValue(new Date());
					}
				}
			},{
				xtype : 'datefield',
				fieldLabel : getCommonTranslation('TO_DATE'),
				name : 'toTime',
				itemId:'courseSessionToDateId',
				startDateField : 'courseSessionFromDateId',
				vtype : 'daterange',
				listeners: {
					render: function(field) {
						field = dateFormatRender(field);						
						field.setValue(new Date());
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'vbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			width:'auto',
			items : [{
				xtype : 'textareafield',
				fieldLabel : getCommonTranslation('TOPICS'),
				name : 'topic',
				maxLength:1000,
				//vtype: 'NospaceAsInput',
				allowBlank:false,
				width: 460,
				listener:{
					blur:function(){}
				}
			}]
		},{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'vbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			width:'auto',
			items : [{
				xtype : 'textareafield',
				fieldLabel : getCommonTranslation('DESCRIPTION'),
				name : 'description',
				maxLength:1000,
				//vtype: 'NospaceAsInput',
				width: 460,
				listener:{
					blur:function(){}
				}
			}]
		} /*{
			 xtype: 'button',
			 width:460,
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadCourseSessionDocumentId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'filefield',
			border:false,
			hidden:false,
			name: 'attachments',
			allowBlank: true,						        
			buttonText: getCommonTranslation('UPLOAD_DOC')
		}]
	},
		{
		xtype:'coursedocumentgrid',
		itemId:'coursedocumentgrid',
		style:{
			marginLeft:'0px'
		},
		hidden:true
	}*/,{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'vbox'
			},
			cls:'horizontal-scrolling-fix',
			defaults : {
				width : 460,
				labelAlign : 'top'
			},
			items : [{
				xtype:'coursesessiondocumentgrid',
				itemId:'coursesessiondocumentgrid',
				style:{
					marginLeft:'0px',
				},
				flex:.1,
				hidden:true
			}]
		
		},{
		xtype: 'fieldcontainer',
		width: '100%',
		cls: 'windowBtnPos',
		items: [{
			xtype: 'button',
			name:'btnSaveCourseSessionDairy',
			itemId: 'btnSaveCourseSessionDairy',
			text: getCommonTranslation('SUBMIT'), //Submit
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind: true
		}, {
			xtype: 'button',
			itemId: 'btnCancelCourseSessionDairy',
			text: getCommonTranslation('CANCEL'), //Cancel
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		},{
			 xtype: 'button',
			 width:460,
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadCourseSessionDocumentId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		
		}]
	}]
	//}]
});