/**
 * @author seshagiri.k
 */
Ext.define('Academia.view.coursetransaction.homework.submissiondetails.SubmissionDetailsGrid', {
	 extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.submissiondetailsgrid',
    store: 'coursetransaction.homework.submissiondetails.SubmissionDetailsGrid',
    border: true,
    autoScroll: false,
    frame:false,
    title : getCourseTxCommonTranslation('HW_SUBMISSION_DETAILS'),	
    viewConfig: {
        stripeRows: true
    },
	isGridConfigurable: true,
	enableColumnHide: false,
    selType:'checkboxmodel',
    selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
    initComponent: function() {

        var grid=this;                   

        grid.addExportToolBarItems(grid);

        this.callParent(arguments);     

 },
 listeners:{
 	beforeselect:function(selModel,record,index){
 		if(!isNullOrEmpty(selModel.view.up())){
 			var gridItemId = selModel.view.up().getItemId();
     			if(record.get('submissionStatus') == 'Completed'){
     				return false;
     			}
     		}
 	}         
 },
    tbar: [{
        xtype: 'button',
        itemId: 'btnEdit',
        text: getCommonTranslation('SUBMITASSIGNMENT'),
        disabled : true
    },{
		xtype : 'button',
		text:getProgramandcourseTranslation('UPLOAD_DOCUMENT'),
		itemId:'submissionUploadDocument',
		disabled : true
	}],
    columns: [{
        header: getCourseTxCommonTranslation('HW_GROUP_NAME'),
        dataIndex: 'groupName',
        flex:1,
        hidden:true,
        sortable:true
    },
	 {
	    header : getCommonTranslation('STUDENT_ID'),
	    dataIndex : 'studentCode',
	    flex:1
	   
	 }, {
        header: getCourseTxCommonTranslation('HW_ADMISSION_ID'),
        dataIndex: 'admissionCode',
        flex:1,
        sortable: true,
      
    }, {
    	header: getCourseTxCommonTranslation('HW_STUDENT_NAME'),
        dataIndex: 'studentName',
        flex:1,
        sortable:true
    }, {
    	header: getCommonTranslation('RANDOM_CODE'),
        dataIndex: 'randomNumber',
        flex:1,
        sortable:true,
        hidden: true
    },{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : 1,
		hidden :true
	},{
    	header: getCourseTxCommonTranslation('HW_ASSIGNMENT_STATUS'),
        dataIndex: 'submissionStatus',
        flex:1,
        sortable:true,
        renderer:function(value,meta,record) {
        	if(value=="Drafted"){
        		return "<font color='#D2691E'>" +"Drafted"+"</font>";
        	}else if(value=="Completed"){
        		return "<font color='green'>" +value+"</font>";	
        	}else if(value=="Submitted"){
        		return "<font color='green'>" +value+"</font>";	
        	}else if(value=="Resubmitted"){
        		return "<font color='green'>" +value+"</font>";	
        	}else{
        		return "<font color='red'>" +value+"</font>";	
        	}	
        }
    },{
    	header: getCourseTxCommonTranslation('HW_SUBMITTED_DATE_ON'),
        dataIndex: 'submissionDate',
        flex:1,
        sortable:true,
		renderer:function(date) {
			return dateTimeRender(date);
		}
    },{
    	header: getCourseTxCommonTranslation('RESUBMISSION_DUE_DATE'),
        dataIndex: 'resubmissionDueDate',
        flex:1,
        sortable:true,
        hidden:true,
		renderer:function(date) {
			return dateTimeRender(date);
		}
    },{
    	header: getProgramandcourseTranslation('HW_RESUBMITTED_DATE_ON'),
        dataIndex: 'resubmissionDate',
        flex:1,
        sortable:true,
		renderer:function(date) {
			return dateTimeRender(date);
		}
    },{
    	header: getCourseTxCommonTranslation('HW_FILE_NAME'),
        dataIndex: 'documents',
        flex:1,
        sortable:true,
        renderer: function (value,meta,record) {
        		if(!isNullOrEmpty(record.data.documents)) {
    				if(record.data.documents.length>1) {					
    					return '<a href=#>'+record.data.documents.length+'<a>';
    				} else if(record.data.documents.length==1) {
    					return '<a href=#>'+record.data.documents[0].name+'<a>';
    				} 
    			}	
		}
    },{
    	header: getProgramandcourseTranslation('DEENROLLED_AFTER_ENROLLMENT'),
    	dataIndex: 'whetherUnEnrolled',
    	sortable:true,
    	flex: 1,
    	hidden:true,
		renderer: function (value,rec) {
			if(!value){
				return 'No';
			}else{
				return 'Yes';
			}
		}
    },{
			header : getProgramandcourseTranslation('RESUBMISSION_COUNT'),
			dataIndex : 'resubmissionCount',
			flex : 1
		}
    ]
});