Ext.define('Academia.view.coursetransaction.pathwaysselection.StudentPathwaysSelectionGrid', {
	extend: 'Ext.grid.Panel',
	alias : 'widget.studentpathwaysselectiongrid',
	store : 'program.programDetails.programBatches.pathwaysConfig.PathwaysSelectionGridStore',
	//title: getProgramandcourseTranslation('PATHWAYS'),
	border: true,
	frame:false,
	cls: 'headerPaddingCls',
	maxHeight:400,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'studentpathwaysselectionstructure':3
		}
	},
	tbar: [{
		xtype: 'button',
		text: getProgramandcourseTranslation('SUBMIT'),
		tooltip: getProgramandcourseTranslation('SUBMIT'),
		itemId: 'submitBtn',
	},{
		 xtype: 'button',
		 text: getCommonTranslation('RESET'),
	     tooltip: getCommonTranslation('RESET'),
		 itemId: 'resetBtn',
	 }],
	columns : [{
		header : getProgramandcourseTranslation('PATHWAY'),
		dataIndex : 'pathwaysPrintName',
		flex:1,
		renderer:function(value) { 
			if (!value) {
				return value;
			}
			var normalized = Ext.String.trim(value).toLowerCase();
			if (normalized === 'no secondary field of study') {
				return value;
			}
			return 'With ' + value;
		}
	},{
		header : getProgramandcourseTranslation('CURRENT_ASSIGNEE'),
		dataIndex : 'currentAssigneeName',
		flex:1
	},{
		header : getProgramandcourseTranslation('ASSIGNED_DATE'),
		dataIndex : 'assigneeDate',
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getProgramandcourseTranslation('STATUS'),
		dataIndex : 'status',
		flex:1
	},{
		header : getProgramandcourseTranslation('REQUEST_DATE'),
		dataIndex : 'requestDate',
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header : getProgramandcourseTranslation('APPROVE_BY'),
		dataIndex : 'approveBy',
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getProgramandcourseTranslation('APPROVAL_DATE'),
		dataIndex : 'approvedDate',
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	}]
});
