Ext.define('Academia.view.coursetransaction.pathwaysselection.StudentPathwaysSelectionMajorListGrid', {
	extend: 'Ext.grid.Panel',
	alias : 'widget.studentpathwaysselectionmajorlistgrid',
	store : 'program.programDetails.programBatches.pathwaysConfig.PathwaysSelectionMajorListGridStore',
	title: getProgramandcourseTranslation('MAJOR_LIST'),
	border: true,
	frame:false,
	selType:'checkboxmodel',
	maxHeight:400,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'studentpathwaysselectionstructure':3
		}
	},
	columns : [{
		header : getProgramandcourseTranslation('MAJOR_GROUP_CODE'),
		dataIndex : 'specializationCode',
		flex:1
	},{
		header : getProgramandcourseTranslation('MAJOR_GROUP_NAME'),
		dataIndex : 'specializationName',
		flex:1
	},{
		header : getProgramandcourseTranslation('NO_OF_ASSOCIATED_COURSE_GROUP'),
		dataIndex : 'noOfAssociatedCourseGroups',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getProgramandcourseTranslation('NO_OF_ASSOCIATED_COURSES'),
		dataIndex : 'noofAssociatedCourses',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getProgramandcourseTranslation('STATUS'),
		dataIndex : 'status',
		flex:1
	},{
		header : getProgramandcourseTranslation('REQUEST_DATE'),
		dataIndex : 'requestDate',
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header : getProgramandcourseTranslation('APPROVE_BY'),
		dataIndex : 'approveBy',
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getProgramandcourseTranslation('APPROVAL_DATE'),
		dataIndex : 'approvedDate',
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	}]
});
