/**
 * Priyanshi Sharma
 * 
 */
Ext.define('Academia.view.coursetransaction.pathwaysselection.StudentPathwaysSelectionSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentpathwaysselectionsearch',  
	plugins : "formlabelrequired",
	frame: false,
	method: 'POST',
	standardSubmit: false,
	cls:'customSearchPanel',
	items: [{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			name : 'studentAcademyLocation',
			itemId:'studentAcademyLocation',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:Ext.create('Academia.store.coursetransaction.studentenrollment.AcademyLocationsByAdmissionStore'),
			valueField : 'id',
			displayField : 'value',
			minChars:3,
			typeAhead : false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			queryParam:'qry',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'studentProgram',
			itemId: 'studentProgramId',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store:'servicerequest.programcoursesectiontransfer.ProgramForSectionTransfer',
			valueField: 'programId',
			displayField: 'programCodeValue',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'studentBatch',
			itemId: 'studentBatchId',
			displayField: 'value',
			store:Ext.create('Academia.store.enquiry.AcademicBatchStore'),
			valueField: 'id',
			queryMode: 'local',
			editable: false,
			fieldLabel: getExaminationTranslation('BATCH'),
			disabled: true
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			disabled: true,
			formBind:true
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE	        				
		}]
	}]
});