/**
 * @author Angad.Yadav
 * 
 */
 Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.ImportExtendedTimeTableUploadTemplatePanel', {
	extend : 'Ext.form.Panel',
	alias : 'widget.importExtendedTimeTableUploadTemplatePanel',
	autoScroll:false,
	frame:false,
	cls: 'horizontalScrollingFixed',
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,
	standardSubmit: false,
    defaults: {
        width: 226,
        labelAlign: 'top'
    },
    plugins: "formlabelrequired",
	method : 'POST',
	items : [{
        xtype: 'customcombobox',
        name: 'importUtilityMasterId',
        itemId: 'moduleName',
        store: 'importutility.ModuleName',
        fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
        valueField: 'id',
        displayField: 'value',
        typeAhead: true,
        forceSelection: true,
        allowBlank: false,
        listeners: {
    		render: function(combo) {
    		    var store = combo.getStore();
    		    var moduleCodeArray = ['ExtendedTimeTable'];

    		    store.load({
    		        callback: function(records, operation, success) {
    		            if (success) {
    		                var filteredRecord = Ext.Array.findBy(records, function(record) {
    		                    return Ext.Array.contains(moduleCodeArray, record.get('code'));
    		                });

    		                if (filteredRecord) {
    		                    combo.setValue(filteredRecord.get('id'));
    		                }
    		            }
    		        }
    		    });
    		}
        },
        listConfig: {
        	listeners: {
        		beforeshow: function(picker) {
        			var pickerComboVal = picker.up('combobox').value;
        			picker.minWidth = picker.up('combobox').getSize().width;
        			var moduleCodeArray = ['ExtendedTimeTable']
        			var store = picker.up('customcombobox').getStore();
        			store.clearFilter(true);
        			setTimeout(function(){
        				store.filterBy(function(record, id){
        					return Ext.Array.contains(moduleCodeArray, record.data.code);
        				});
        			},300);
        		}
        	},
        	loadingText: getCommonTranslation('SEARCHING'),
        	emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        	getInnerTpl: function() {
        		return '<div class="search-item">' +
        		'{value}' +
        		'</div>';
        	}
        }
    },{
        xtype: 'filefield',
        ui: 'CustomBtnThird',
        width: 460,
        fieldLabel: getCommonTranslation('UPLOAD_FILE'),
        buttonText: getCommonTranslation('BROWSE_FILE'),
        itemId: 'uploadFileField',
        name: 'file',
        allowBlank: false,
        validateOnChange: true,
        listeners: {
            change: function(fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
                    }
                }
            }
        }
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        style:{
			marginTop:'20px !important'
		},
        items: [{
            xtype: 'button',
            action: 'Submit',
            text: getTranslation('UPLOAD_DATA'),
            formBind: true,
            itemId: 'uploadExtendedTimeTableBtn',
            ui: 'CustomBtnSubmit',
            style:{marginLeft:'0px !important'},
			scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            itemId: 'resetBtnImportSessionTopicUploadFormItemId',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});
